/*
 * Decompiled with CFR 0.152.
 */
package io.perfmark.impl;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;

final class ThreadRef
extends WeakReference<Thread> {
    private static final ThreadRef IDENTITY = new ThreadRef();
    private final int hashCode;

    static ThreadRef newRef(ReferenceQueue<Thread> queue) {
        return new ThreadRef(Thread.currentThread(), queue);
    }

    static <T> T get(Map<ThreadRef, T> map) {
        return map.get(IDENTITY);
    }

    static <T> T removeAndClearRef(Map<ThreadRef, T> map) {
        return map.remove(IDENTITY);
    }

    private ThreadRef(Thread thread, ReferenceQueue<Thread> queue) {
        super(thread, queue);
        this.hashCode = System.identityHashCode(thread);
    }

    private ThreadRef() {
        super(null);
        this.hashCode = 0;
    }

    @Override
    @Deprecated
    public void clear() {
    }

    @Override
    @Deprecated
    public boolean enqueue() {
        return false;
    }

    void clearSafe() {
        super.clear();
    }

    boolean enqueueSafe() {
        return super.enqueue();
    }

    public int hashCode() {
        if (this == IDENTITY) {
            return System.identityHashCode(Thread.currentThread());
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ThreadRef)) {
            return false;
        }
        ThreadRef that = (ThreadRef)obj;
        boolean isEqual = this == IDENTITY ? Thread.currentThread() == that.get() : this.get() == that.get();
        return isEqual;
    }
}

