/*
 * Decompiled with CFR 0.152.
 */
package io.perfmark.impl;

import io.perfmark.impl.MarkHolder;
import io.perfmark.impl.MarkHolderProvider;
import io.perfmark.impl.MarkList;
import io.perfmark.impl.Marker;
import io.perfmark.impl.NoopMarkHolderProvider;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class Storage {
    private static final long INIT_NANO_TIME = System.nanoTime();
    static final ConcurrentMap<MarkHolderRef, Reference<? extends Thread>> allMarkHolders = new ConcurrentHashMap<MarkHolderRef, Reference<? extends Thread>>();
    private static final ThreadLocal<MarkHolder> localMarkHolder = new MarkHolderThreadLocal();
    static final MarkHolderProvider markHolderProvider;
    private static final Logger logger;

    public static long getInitNanoTime() {
        return INIT_NANO_TIME;
    }

    public static List<MarkList> read() {
        MarkHolderRef.cleanQueue(allMarkHolders);
        ArrayList<Thread> threads = new ArrayList<Thread>();
        ArrayList<Long> markHolderIds = new ArrayList<Long>();
        ArrayList<MarkHolder> markHolders = new ArrayList<MarkHolder>();
        for (Map.Entry entry : allMarkHolders.entrySet()) {
            MarkHolder mh = (MarkHolder)((MarkHolderRef)entry.getKey()).get();
            if (mh == null) continue;
            Thread writer = (Thread)((Reference)entry.getValue()).get();
            markHolders.add(mh);
            markHolderIds.add(((MarkHolderRef)entry.getKey()).markHolderId);
            threads.add(writer);
        }
        assert (markHolders.size() == threads.size());
        ArrayList<MarkList> markLists = new ArrayList<MarkList>(markHolders.size());
        long noThreadIds = -1L;
        for (int i = 0; i < markHolders.size(); ++i) {
            long threadId;
            String threadName;
            Thread writer = (Thread)threads.get(i);
            if (writer == null) {
                --noThreadIds;
                threadName = "(unknownThread)";
            } else {
                threadId = writer.getId();
                threadName = writer.getName();
            }
            boolean readerIsWriter = Thread.currentThread() == writer;
            markLists.add(MarkList.newBuilder().setMarks(((MarkHolder)markHolders.get(i)).read(readerIsWriter)).setThreadName(threadName).setThreadId(threadId).setMarkListId((Long)markHolderIds.get(i)).build());
        }
        return Collections.unmodifiableList(markLists);
    }

    static void startAnyways(long gen, String taskName, @Nullable String tagName, long tagId) {
        localMarkHolder.get().start(gen, taskName, tagName, tagId, System.nanoTime());
    }

    static void startAnyways(long gen, Marker marker, @Nullable String tagName, long tagId) {
        localMarkHolder.get().start(gen, marker, tagName, tagId, System.nanoTime());
    }

    static void startAnyways(long gen, String taskName) {
        localMarkHolder.get().start(gen, taskName, System.nanoTime());
    }

    static void startAnyways(long gen, Marker marker) {
        localMarkHolder.get().start(gen, marker, System.nanoTime());
    }

    static void stopAnyways(long gen, String taskName, @Nullable String tagName, long tagId) {
        long nanoTime = System.nanoTime();
        localMarkHolder.get().stop(gen, taskName, tagName, tagId, nanoTime);
    }

    static void stopAnyways(long gen, Marker marker, @Nullable String tagName, long tagId) {
        long nanoTime = System.nanoTime();
        localMarkHolder.get().stop(gen, marker, tagName, tagId, nanoTime);
    }

    static void stopAnyways(long gen, String taskName) {
        long nanoTime = System.nanoTime();
        localMarkHolder.get().stop(gen, taskName, nanoTime);
    }

    static void stopAnyways(long gen, Marker marker) {
        long nanoTime = System.nanoTime();
        localMarkHolder.get().stop(gen, marker, nanoTime);
    }

    static void eventAnyways(long gen, String eventName, @Nullable String tagName, long tagId) {
        long nanoTime = System.nanoTime();
        localMarkHolder.get().event(gen, eventName, tagName, tagId, nanoTime, 0L);
    }

    static void eventAnyways(long gen, Marker marker, @Nullable String tagName, long tagId) {
        long nanoTime = System.nanoTime();
        localMarkHolder.get().event(gen, marker, tagName, tagId, nanoTime, 0L);
    }

    static void eventAnyways(long gen, String eventName) {
        long nanoTime = System.nanoTime();
        localMarkHolder.get().event(gen, eventName, nanoTime, 0L);
    }

    static void eventAnyways(long gen, Marker marker) {
        long nanoTime = System.nanoTime();
        localMarkHolder.get().event(gen, marker, nanoTime, 0L);
    }

    static void linkAnyways(long gen, long linkId, Marker marker) {
        localMarkHolder.get().link(gen, linkId, marker);
    }

    public static void resetForTest() {
        localMarkHolder.get().resetForTest();
    }

    private static boolean errorsEqual(Throwable t1, Throwable t2) {
        String msg2;
        String msg1;
        if (t1 == null || t2 == null) {
            return t1 == t2;
        }
        if (t1.getClass() == t2.getClass() && ((msg1 = t1.getMessage()) == (msg2 = t2.getMessage()) || msg1 != null && msg1.equals(msg2)) && Arrays.equals(t1.getStackTrace(), t2.getStackTrace())) {
            return Storage.errorsEqual(t1.getCause(), t2.getCause());
        }
        return false;
    }

    private Storage() {
        throw new AssertionError((Object)"nope");
    }

    static {
        ArrayList<MarkHolderProvider> providers = new ArrayList<MarkHolderProvider>();
        ArrayList<ClassNotFoundException> fines = new ArrayList<ClassNotFoundException>();
        ArrayList<Throwable> warnings = new ArrayList<Throwable>();
        Class<?> clz = null;
        try {
            clz = Class.forName("io.perfmark.java9.SecretVarHandleMarkHolderProvider$VarHandleMarkHolderProvider");
        }
        catch (ClassNotFoundException e) {
            fines.add(e);
        }
        catch (Throwable t) {
            warnings.add(t);
        }
        if (clz != null) {
            try {
                providers.add(clz.asSubclass(MarkHolderProvider.class).getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Throwable t) {
                warnings.add(t);
            }
            clz = null;
        }
        try {
            clz = Class.forName("io.perfmark.java6.SecretSynchronizedMarkHolderProvider$SynchronizedMarkHolderProvider");
        }
        catch (ClassNotFoundException e) {
            fines.add(e);
        }
        catch (Throwable t) {
            warnings.add(t);
        }
        if (clz != null) {
            try {
                providers.add(clz.asSubclass(MarkHolderProvider.class).getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Throwable t) {
                warnings.add(t);
            }
            clz = null;
        }
        markHolderProvider = !providers.isEmpty() ? (MarkHolderProvider)providers.get(0) : new NoopMarkHolderProvider();
        logger = Logger.getLogger(Storage.class.getName());
        for (Throwable throwable : warnings) {
            logger.log(Level.WARNING, "Error loading MarkHolderProvider", throwable);
        }
        for (Throwable throwable : fines) {
            logger.log(Level.FINE, "Error loading MarkHolderProvider", throwable);
        }
    }

    private static final class MarkHolderRef
    extends WeakReference<MarkHolder> {
        private static final ReferenceQueue<MarkHolder> markHolderRefQueue = new ReferenceQueue();
        private static final AtomicLong markHolderIdAllocator = new AtomicLong();
        final long markHolderId = markHolderIdAllocator.incrementAndGet();

        MarkHolderRef(MarkHolder holder) {
            super(holder, markHolderRefQueue);
        }

        static void cleanQueue(Map<?, ?> allSpans) {
            Reference<MarkHolder> ref;
            while ((ref = markHolderRefQueue.poll()) != null) {
                ref.clear();
                allSpans.remove(ref);
            }
        }
    }

    private static final class MarkHolderThreadLocal
    extends ThreadLocal<MarkHolder> {
        MarkHolderThreadLocal() {
        }

        @Override
        protected MarkHolder initialValue() {
            MarkHolderRef.cleanQueue(allMarkHolders);
            MarkHolder holder = markHolderProvider.create();
            MarkHolderRef ref = new MarkHolderRef(holder);
            WeakReference<Thread> writer = new WeakReference<Thread>(Thread.currentThread());
            allMarkHolders.put(ref, writer);
            return holder;
        }
    }
}

