/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.extension.core;

import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.extension.Filter;
import com.mitchellbosecke.pebble.extension.escaper.SafeString;
import com.mitchellbosecke.pebble.template.EvaluationContext;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DateFilter
implements Filter {
    private final List<String> argumentNames = new ArrayList<String>();

    public DateFilter() {
        this.argumentNames.add("format");
        this.argumentNames.add("existingFormat");
    }

    @Override
    public List<String> getArgumentNames() {
        return this.argumentNames;
    }

    @Override
    public Object apply(Object input, Map<String, Object> args, PebbleTemplate self, EvaluationContext context, int lineNumber) throws PebbleException {
        if (input == null) {
            return null;
        }
        Locale locale = context.getLocale();
        String format = (String)args.get("format");
        if (TemporalAccessor.class.isAssignableFrom(input.getClass())) {
            return this.applyTemporal((TemporalAccessor)input, self, locale, lineNumber, format);
        }
        return this.applyDate(input, self, locale, lineNumber, format, (String)args.get("existingFormat"));
    }

    private Object applyDate(Object dateOrString, PebbleTemplate self, Locale locale, int lineNumber, String format, String existingFormatString) throws PebbleException {
        Date date;
        if (existingFormatString != null) {
            SimpleDateFormat existingFormat = new SimpleDateFormat(existingFormatString, locale);
            try {
                date = existingFormat.parse(dateOrString.toString());
            }
            catch (ParseException e) {
                throw new PebbleException(e, String.format("Could not parse the string '%s' into a date.", dateOrString.toString()), lineNumber, self.getName());
            }
        } else if (dateOrString instanceof Date) {
            date = (Date)dateOrString;
        } else if (dateOrString instanceof Number) {
            date = new Date(((Number)dateOrString).longValue());
        } else {
            throw new IllegalArgumentException(String.format("Unsupported argument type: %s (value: %s)", dateOrString.getClass().getName(), dateOrString));
        }
        SimpleDateFormat intendedFormat = new SimpleDateFormat(format, locale);
        return new SafeString(intendedFormat.format(date));
    }

    private Object applyTemporal(TemporalAccessor input, PebbleTemplate self, Locale locale, int lineNumber, String format) throws PebbleException {
        DateTimeFormatter formatter = format != null ? DateTimeFormatter.ofPattern(format, locale) : DateTimeFormatter.ISO_DATE_TIME;
        try {
            return new SafeString(formatter.format(input));
        }
        catch (DateTimeException dte) {
            throw new PebbleException(dte, String.format("Could not parse the string '%s' into a date.", input.toString()), lineNumber, self.getName());
        }
    }
}

