/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.node;

import com.mitchellbosecke.pebble.extension.NodeVisitor;
import com.mitchellbosecke.pebble.node.AbstractRenderableNode;
import com.mitchellbosecke.pebble.node.BodyNode;
import com.mitchellbosecke.pebble.template.EvaluationContext;
import com.mitchellbosecke.pebble.template.PebbleTemplateImpl;
import com.mitchellbosecke.pebble.utils.FutureWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelNode
extends AbstractRenderableNode {
    private final Logger logger = LoggerFactory.getLogger(ParallelNode.class);
    private final BodyNode body;
    private boolean hasWarnedAboutNonExistingExecutorService = false;

    public ParallelNode(int lineNumber, BodyNode body) {
        super(lineNumber);
        this.body = body;
    }

    @Override
    public void render(final PebbleTemplateImpl self, Writer writer, EvaluationContext context) throws IOException {
        ExecutorService es = context.getExecutorService();
        if (es == null) {
            if (!this.hasWarnedAboutNonExistingExecutorService) {
                this.logger.info(String.format("The parallel tag was used [%s:%d] but no ExecutorService was provided. The parallel tag will be ignored and it's contents will be rendered in sequence with the rest of the template.", self.getName(), this.getLineNumber()));
                this.hasWarnedAboutNonExistingExecutorService = true;
            }
            this.body.render(self, writer, context);
        } else {
            final EvaluationContext contextCopy = context.threadSafeCopy(self);
            final StringWriter newStringWriter = new StringWriter();
            final FutureWriter newFutureWriter = new FutureWriter(newStringWriter);
            Future<String> future = es.submit(new Callable<String>(){

                @Override
                public String call() throws IOException {
                    ParallelNode.this.body.render(self, newFutureWriter, contextCopy);
                    newFutureWriter.flush();
                    newFutureWriter.close();
                    return newStringWriter.toString();
                }
            });
            ((FutureWriter)writer).enqueue(future);
        }
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    public BodyNode getBody() {
        return this.body;
    }
}

