/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.template;

import com.google.common.cache.Cache;
import com.mitchellbosecke.pebble.cache.CacheKey;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.extension.ExtensionRegistry;
import com.mitchellbosecke.pebble.template.EvaluationOptions;
import com.mitchellbosecke.pebble.template.Hierarchy;
import com.mitchellbosecke.pebble.template.PebbleTemplateImpl;
import com.mitchellbosecke.pebble.template.ScopeChain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class EvaluationContext {
    private final boolean strictVariables;
    private final Hierarchy hierarchy;
    private final ScopeChain scopeChain;
    private final Locale locale;
    private final ExtensionRegistry extensionRegistry;
    private final Cache<CacheKey, Object> tagCache;
    private final ExecutorService executorService;
    private final List<PebbleTemplateImpl> importedTemplates;
    private final Map<String, PebbleTemplateImpl> namedImportedTemplates;
    private final EvaluationOptions evaluationOptions;

    public EvaluationContext(PebbleTemplateImpl self, boolean strictVariables, Locale locale, ExtensionRegistry extensionRegistry, Cache<CacheKey, Object> tagCache, ExecutorService executorService, List<PebbleTemplateImpl> importedTemplates, Map<String, PebbleTemplateImpl> namedImportedTemplates, ScopeChain scopeChain, Hierarchy hierarchy, EvaluationOptions evaluationOptions) {
        if (hierarchy == null) {
            hierarchy = new Hierarchy(self);
        }
        this.strictVariables = strictVariables;
        this.locale = locale;
        this.extensionRegistry = extensionRegistry;
        this.tagCache = tagCache;
        this.executorService = executorService;
        this.importedTemplates = importedTemplates;
        this.namedImportedTemplates = namedImportedTemplates;
        this.scopeChain = scopeChain;
        this.hierarchy = hierarchy;
        this.evaluationOptions = evaluationOptions;
    }

    public EvaluationContext shallowCopyWithoutInheritanceChain(PebbleTemplateImpl self) {
        EvaluationContext result = new EvaluationContext(self, this.strictVariables, this.locale, this.extensionRegistry, this.tagCache, this.executorService, this.importedTemplates, this.namedImportedTemplates, this.scopeChain, null, this.evaluationOptions);
        return result;
    }

    public EvaluationContext threadSafeCopy(PebbleTemplateImpl self) {
        EvaluationContext result = new EvaluationContext(self, this.strictVariables, this.locale, this.extensionRegistry, this.tagCache, this.executorService, new ArrayList<PebbleTemplateImpl>(this.importedTemplates), new HashMap<String, PebbleTemplateImpl>(this.namedImportedTemplates), this.scopeChain.deepCopy(), this.hierarchy, this.evaluationOptions);
        return result;
    }

    public boolean isStrictVariables() {
        return this.strictVariables;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ExtensionRegistry getExtensionRegistry() {
        return this.extensionRegistry;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public List<PebbleTemplateImpl> getImportedTemplates() {
        return this.importedTemplates;
    }

    public PebbleTemplateImpl getNamedImportedTemplate(String alias) {
        return this.namedImportedTemplates.get(alias);
    }

    public void addNamedImportedTemplates(String alias, PebbleTemplateImpl template) {
        if (this.namedImportedTemplates.containsKey(alias)) {
            throw new PebbleException(null, "More than one named template can not share the same name: " + alias);
        }
        this.namedImportedTemplates.put(alias, template);
    }

    public Cache<CacheKey, Object> getTagCache() {
        return this.tagCache;
    }

    public ScopeChain getScopeChain() {
        return this.scopeChain;
    }

    public Hierarchy getHierarchy() {
        return this.hierarchy;
    }

    public EvaluationOptions getEvaluationOptions() {
        return this.evaluationOptions;
    }
}

