/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.loader;

import com.mitchellbosecke.pebble.error.LoaderException;
import com.mitchellbosecke.pebble.loader.DelegatingLoaderCacheKey;
import com.mitchellbosecke.pebble.loader.Loader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DelegatingLoader
implements Loader<DelegatingLoaderCacheKey> {
    private String prefix;
    private String suffix;
    private String charset = "UTF-8";
    private final List<Loader<?>> loaders;

    public DelegatingLoader(List<Loader<?>> loaders) {
        this.loaders = Collections.unmodifiableList(new ArrayList(loaders));
    }

    @Override
    public Reader getReader(DelegatingLoaderCacheKey cacheKey) {
        Reader reader = null;
        int size = this.loaders.size();
        for (int i = 0; i < size; ++i) {
            Loader<?> loader = this.loaders.get(i);
            Object delegatingKey = cacheKey.getDelegatingCacheKeys().get(i);
            try {
                reader = this.getReaderInner(loader, delegatingKey);
                if (reader == null) continue;
                break;
            }
            catch (LoaderException loaderException) {
                // empty catch block
            }
        }
        if (reader == null) {
            throw new LoaderException(null, "Could not find template \"" + cacheKey.getTemplateName() + "\"");
        }
        return reader;
    }

    private <T> Reader getReaderInner(Loader<T> delegatingLoader, Object cacheKey) {
        Object castedKey = cacheKey;
        return delegatingLoader.getReader(castedKey);
    }

    public String getSuffix() {
        return this.suffix;
    }

    @Override
    public void setSuffix(String suffix) {
        this.suffix = suffix;
        for (Loader<?> loader : this.loaders) {
            loader.setSuffix(suffix);
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = prefix;
        for (Loader<?> loader : this.loaders) {
            loader.setPrefix(prefix);
        }
    }

    public String getCharset() {
        return this.charset;
    }

    @Override
    public void setCharset(String charset) {
        this.charset = charset;
        for (Loader<?> loader : this.loaders) {
            loader.setCharset(charset);
        }
    }

    @Override
    public String resolveRelativePath(String relativePath, String anchorPath) {
        if (relativePath == null) {
            return relativePath;
        }
        for (Loader<?> loader : this.loaders) {
            String path = loader.resolveRelativePath(relativePath, anchorPath);
            if (path == null) continue;
            return path;
        }
        return null;
    }

    @Override
    public DelegatingLoaderCacheKey createCacheKey(String templateName) {
        ArrayList<Object> keys = new ArrayList<Object>();
        for (Loader<?> loader : this.loaders) {
            keys.add(loader.createCacheKey(templateName));
        }
        return new DelegatingLoaderCacheKey(keys, templateName);
    }
}

