/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mitchellbosecke.pebble.cache.CacheKey;
import com.mitchellbosecke.pebble.error.LoaderException;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.extension.Extension;
import com.mitchellbosecke.pebble.extension.ExtensionRegistry;
import com.mitchellbosecke.pebble.extension.NodeVisitorFactory;
import com.mitchellbosecke.pebble.extension.core.CoreExtension;
import com.mitchellbosecke.pebble.extension.escaper.EscaperExtension;
import com.mitchellbosecke.pebble.extension.escaper.EscapingStrategy;
import com.mitchellbosecke.pebble.extension.i18n.I18nExtension;
import com.mitchellbosecke.pebble.lexer.LexerImpl;
import com.mitchellbosecke.pebble.lexer.Syntax;
import com.mitchellbosecke.pebble.lexer.TokenStream;
import com.mitchellbosecke.pebble.loader.ClasspathLoader;
import com.mitchellbosecke.pebble.loader.DelegatingLoader;
import com.mitchellbosecke.pebble.loader.FileLoader;
import com.mitchellbosecke.pebble.loader.Loader;
import com.mitchellbosecke.pebble.node.RootNode;
import com.mitchellbosecke.pebble.parser.ParserImpl;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import com.mitchellbosecke.pebble.template.PebbleTemplateImpl;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;

public class PebbleEngine {
    private final Loader<?> loader;
    private final Syntax syntax;
    private final boolean strictVariables;
    private final Locale defaultLocale;
    private final Cache<CacheKey, Object> tagCache;
    private final ExecutorService executorService;
    private final Cache<Object, PebbleTemplate> templateCache;
    private final ExtensionRegistry extensionRegistry;
    private final boolean allowGetClass;

    private PebbleEngine(Loader<?> loader, Syntax syntax, boolean strictVariables, Locale defaultLocale, Cache<CacheKey, Object> tagCache, Cache<Object, PebbleTemplate> templateCache, ExecutorService executorService, Collection<? extends Extension> extensions, boolean allowGetClass) {
        this.loader = loader;
        this.syntax = syntax;
        this.strictVariables = strictVariables;
        this.defaultLocale = defaultLocale;
        this.tagCache = tagCache;
        this.executorService = executorService;
        this.templateCache = templateCache;
        this.extensionRegistry = new ExtensionRegistry(extensions);
        this.allowGetClass = allowGetClass;
    }

    public PebbleTemplate getTemplate(final String templateName) {
        PebbleTemplate result;
        if (templateName == null) {
            return null;
        }
        if (this.loader == null) {
            throw new LoaderException(null, "Loader has not yet been specified.");
        }
        final PebbleEngine self = this;
        try {
            final Object cacheKey = this.loader.createCacheKey(templateName);
            result = (PebbleTemplate)this.templateCache.get(cacheKey, (Callable)new Callable<PebbleTemplate>(){

                @Override
                public PebbleTemplateImpl call() {
                    LexerImpl lexer = new LexerImpl(PebbleEngine.this.syntax, PebbleEngine.this.extensionRegistry.getUnaryOperators().values(), PebbleEngine.this.extensionRegistry.getBinaryOperators().values());
                    Reader templateReader = self.retrieveReaderFromLoader(self.loader, cacheKey);
                    TokenStream tokenStream = lexer.tokenize(templateReader, templateName);
                    ParserImpl parser = new ParserImpl(PebbleEngine.this.extensionRegistry.getUnaryOperators(), PebbleEngine.this.extensionRegistry.getBinaryOperators(), PebbleEngine.this.extensionRegistry.getTokenParsers());
                    RootNode root = parser.parse(tokenStream);
                    PebbleTemplateImpl instance = new PebbleTemplateImpl(self, root, templateName);
                    for (NodeVisitorFactory visitorFactory : PebbleEngine.this.extensionRegistry.getNodeVisitors()) {
                        visitorFactory.createVisitor(instance).visit(root);
                    }
                    return instance;
                }
            });
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof PebbleException) {
                throw (PebbleException)e.getCause();
            }
            throw new PebbleException(e, String.format("An error occurred while compiling %s", templateName));
        }
        return result;
    }

    private <T> Reader retrieveReaderFromLoader(Loader<T> loader, Object cacheKey) {
        Object casted = cacheKey;
        return loader.getReader(casted);
    }

    public Loader<?> getLoader() {
        return this.loader;
    }

    public Cache<Object, PebbleTemplate> getTemplateCache() {
        return this.templateCache;
    }

    public boolean isStrictVariables() {
        return this.strictVariables;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public Syntax getSyntax() {
        return this.syntax;
    }

    public ExtensionRegistry getExtensionRegistry() {
        return this.extensionRegistry;
    }

    public Cache<CacheKey, Object> getTagCache() {
        return this.tagCache;
    }

    public boolean isAllowGetClass() {
        return this.allowGetClass;
    }

    public static class Builder {
        private Loader<?> loader;
        private List<Extension> userProvidedExtensions = new ArrayList<Extension>();
        private Syntax syntax;
        private boolean strictVariables = false;
        private boolean enableNewLineTrimming = true;
        private Locale defaultLocale;
        private ExecutorService executorService;
        private Cache<Object, PebbleTemplate> templateCache;
        private boolean cacheActive = true;
        private Cache<CacheKey, Object> tagCache;
        private EscaperExtension escaperExtension = new EscaperExtension();
        private boolean allowGetClass = true;

        public Builder loader(Loader<?> loader) {
            this.loader = loader;
            return this;
        }

        public Builder extension(Extension ... extensions) {
            for (Extension extension : extensions) {
                this.userProvidedExtensions.add(extension);
            }
            return this;
        }

        public Builder syntax(Syntax syntax) {
            this.syntax = syntax;
            return this;
        }

        public Builder strictVariables(boolean strictVariables) {
            this.strictVariables = strictVariables;
            return this;
        }

        public Builder newLineTrimming(boolean enableNewLineTrimming) {
            this.enableNewLineTrimming = enableNewLineTrimming;
            return this;
        }

        public Builder defaultLocale(Locale defaultLocale) {
            this.defaultLocale = defaultLocale;
            return this;
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder templateCache(Cache<Object, PebbleTemplate> templateCache) {
            this.templateCache = templateCache;
            return this;
        }

        public Builder tagCache(Cache<CacheKey, Object> tagCache) {
            this.tagCache = tagCache;
            return this;
        }

        public Builder autoEscaping(boolean autoEscaping) {
            this.escaperExtension.setAutoEscaping(autoEscaping);
            return this;
        }

        public Builder defaultEscapingStrategy(String strategy) {
            this.escaperExtension.setDefaultStrategy(strategy);
            return this;
        }

        public Builder addEscapingStrategy(String name, EscapingStrategy strategy) {
            this.escaperExtension.addEscapingStrategy(name, strategy);
            return this;
        }

        public Builder cacheActive(boolean cacheActive) {
            this.cacheActive = cacheActive;
            return this;
        }

        public Builder allowGetClass(boolean allowGetClass) {
            this.allowGetClass = allowGetClass;
            return this;
        }

        public PebbleEngine build() {
            ArrayList<Extension> extensions = new ArrayList<Extension>();
            extensions.add(new CoreExtension());
            extensions.add(this.escaperExtension);
            extensions.add(new I18nExtension());
            extensions.addAll(this.userProvidedExtensions);
            if (this.loader == null) {
                ArrayList defaultLoadingStrategies = new ArrayList();
                defaultLoadingStrategies.add(new ClasspathLoader());
                defaultLoadingStrategies.add(new FileLoader());
                this.loader = new DelegatingLoader(defaultLoadingStrategies);
            }
            if (this.defaultLocale == null) {
                this.defaultLocale = Locale.getDefault();
            }
            if (this.cacheActive) {
                if (this.templateCache == null) {
                    this.templateCache = CacheBuilder.newBuilder().maximumSize(200L).build();
                }
                if (this.tagCache == null) {
                    this.tagCache = CacheBuilder.newBuilder().maximumSize(200L).build();
                }
            } else {
                this.templateCache = CacheBuilder.newBuilder().maximumSize(0L).build();
                this.tagCache = CacheBuilder.newBuilder().maximumSize(0L).build();
            }
            if (this.syntax == null) {
                this.syntax = new Syntax.Builder().setEnableNewLineTrimming(this.enableNewLineTrimming).build();
            }
            return new PebbleEngine(this.loader, this.syntax, this.strictVariables, this.defaultLocale, this.tagCache, this.templateCache, this.executorService, extensions, this.allowGetClass);
        }
    }
}

