/*
 * Decompiled with CFR 0.152.
 */
package io.pebbletemplates.boot.autoconfigure;

import io.pebbletemplates.boot.autoconfigure.AbstractPebbleConfiguration;
import io.pebbletemplates.boot.autoconfigure.PebbleProperties;
import io.pebbletemplates.pebble.PebbleEngine;
import io.pebbletemplates.pebble.loader.ClasspathLoader;
import io.pebbletemplates.spring.servlet.PebbleViewResolver;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
class PebbleServletWebConfiguration
extends AbstractPebbleConfiguration {
    PebbleServletWebConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean(name={"pebbleViewResolver"})
    PebbleViewResolver pebbleViewResolver(PebbleProperties properties, PebbleEngine pebbleEngine) {
        PebbleViewResolver pvr = new PebbleViewResolver(pebbleEngine);
        properties.applyToMvcViewResolver(pvr);
        if (pebbleEngine.getLoader() instanceof ClasspathLoader) {
            pvr.setPrefix(this.stripLeadingSlash(properties.getPrefix()));
        }
        return pvr;
    }
}

