/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.utils;

import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import io.particle.android.sdk.utils.ParticleDeviceSetupInternalStringUtils;
import io.particle.android.sdk.utils.Preconditions;
import java.util.Locale;

public class SSID
implements Comparable<SSID>,
Parcelable {
    private final String ssidString;
    public static final Parcelable.Creator<SSID> CREATOR = new Parcelable.Creator<SSID>(){

        public SSID createFromParcel(Parcel in) {
            return new SSID(in.readString());
        }

        public SSID[] newArray(int size) {
            return new SSID[size];
        }
    };

    public static SSID from(@NonNull String rawSsidString) {
        Preconditions.checkNotNull((Object)rawSsidString);
        return new SSID(SSID.deQuotifySsid(rawSsidString));
    }

    public static SSID from(WifiInfo wifiInfo) {
        return SSID.from(wifiInfo.getSSID());
    }

    public static SSID from(WifiConfiguration wifiConfiguration) {
        return SSID.from(wifiConfiguration.SSID);
    }

    public static SSID from(ScanResult scanResult) {
        return SSID.from(scanResult.SSID);
    }

    private SSID(String ssidString) {
        this.ssidString = ssidString;
    }

    public String toString() {
        return this.ssidString;
    }

    public String inQuotes() {
        return "\"" + this.ssidString + "\"";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SSID ssid = (SSID)o;
        return this.ssidString.equalsIgnoreCase(ssid.ssidString);
    }

    public int hashCode() {
        return this.ssidString.toLowerCase(Locale.ROOT).hashCode();
    }

    @Override
    public int compareTo(@NonNull SSID o) {
        return this.ssidString.compareToIgnoreCase(o.ssidString);
    }

    private static String deQuotifySsid(String SSID2) {
        String quoteMark = "\"";
        SSID2 = ParticleDeviceSetupInternalStringUtils.removeStart(SSID2, quoteMark);
        SSID2 = ParticleDeviceSetupInternalStringUtils.removeEnd(SSID2, quoteMark);
        return SSID2;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.ssidString);
    }
}

