/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.utils;

import io.particle.android.sdk.utils.TLog;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Locale;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import okio.ByteString;
import org.spongycastle.asn1.ASN1InputStream;
import org.spongycastle.asn1.ASN1Integer;
import org.spongycastle.asn1.ASN1Primitive;
import org.spongycastle.asn1.DLSequence;
import org.spongycastle.asn1.x509.SubjectPublicKeyInfo;

@ParametersAreNonnullByDefault
public class Crypto {
    private static final TLog log = TLog.get(Crypto.class);

    public static PublicKey readPublicKeyFromHexEncodedDerString(String hexString) throws CryptoException {
        byte[] rawBytes = ByteString.decodeHex((String)hexString).toByteArray();
        return Crypto.buildPublicKey(rawBytes);
    }

    public static String encryptAndEncodeToHex(String inputString, PublicKey publicKey) throws CryptoException {
        Charset utf8 = Charset.forName("UTF-8");
        byte[] asBytes = inputString.getBytes(utf8);
        byte[] encryptedBytes = Crypto.encryptWithKey(asBytes, publicKey);
        String hex = ByteString.of((byte[])encryptedBytes).hex();
        return hex.toLowerCase(Locale.ROOT);
    }

    static byte[] encryptWithKey(byte[] inputData, PublicKey publicKey) throws CryptoException {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(1, publicKey);
            return cipher.doFinal(inputData);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            log.e("Error while encrypting bytes: ", (Throwable)e);
            throw new CryptoException(e);
        }
    }

    static PublicKey buildPublicKey(byte[] rawBytes) throws CryptoException {
        try {
            ASN1InputStream bIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(rawBytes));
            SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance((Object)new ASN1InputStream(bIn.readObject().getEncoded()).readObject());
            DLSequence dlSequence = (DLSequence)ASN1Primitive.fromByteArray((byte[])info.getPublicKeyData().getBytes());
            BigInteger modulus = ((ASN1Integer)dlSequence.getObjectAt(0)).getPositiveValue();
            BigInteger exponent = ((ASN1Integer)dlSequence.getObjectAt(1)).getPositiveValue();
            RSAPublicKeySpec spec = new RSAPublicKeySpec(modulus, exponent);
            KeyFactory kf = Crypto.getRSAKeyFactory();
            return kf.generatePublic(spec);
        }
        catch (IOException | InvalidKeySpecException e) {
            throw new CryptoException(e);
        }
    }

    static KeyFactory getRSAKeyFactory() {
        try {
            return KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("This should be impossible, but there is no RSA impl on this device", e);
        }
    }

    public static class CryptoException
    extends Exception {
        public CryptoException(Throwable cause) {
            super(cause);
        }
    }
}

