/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.ui;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.ListFragment;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import io.particle.android.sdk.devicesetup.R;
import io.particle.android.sdk.devicesetup.model.WifiNetwork;
import io.particle.android.sdk.utils.EZ;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.TLog;
import io.particle.android.sdk.utils.ui.Ui;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;

public class WifiListFragment<T extends WifiNetwork>
extends ListFragment
implements LoaderManager.LoaderCallbacks<Set<T>> {
    private static final TLog log = TLog.get(WifiListFragment.class);
    private WifiNetworkAdapter adapter;
    private Runnable aggroLoadingRunnable;
    private Handler aggroLoadingHandler;
    private Client<T> client;
    private Set<T> previousData = Py.set((Object[])new WifiNetwork[0]);

    public void scanAsync() {
        if (this.isDetached() || this.client == null) {
            this.stopAggroLoading();
        } else {
            Loader loader = this.getLoaderManager().getLoader(((Object)((Object)this)).getClass().hashCode());
            loader.forceLoad();
        }
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        this.client = (Client)EZ.getCallbacksOrThrow((Fragment)this, Client.class);
        if (this.aggroLoadingHandler == null) {
            this.aggroLoadingHandler = new Handler();
        }
    }

    public void onViewCreated(@NonNull View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.adapter = new WifiNetworkAdapter((Context)this.getActivity());
        this.setEmptyText(this.client.getListEmptyText());
        this.getLoaderManager().initLoader(((Object)((Object)this)).getClass().hashCode(), null, (LoaderManager.LoaderCallbacks)this);
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.getListView().setVerticalScrollBarEnabled(true);
        this.getListView().setScrollbarFadingEnabled(false);
    }

    public void onStart() {
        super.onStart();
        this.scanAsync();
        this.startAggroLoading();
    }

    public void onStop() {
        super.onStop();
        this.stopAggroLoading();
    }

    public void onDetach() {
        this.client = null;
        super.onDetach();
    }

    public void onListItemClick(ListView l, View v, int position, long id2) {
        super.onListItemClick(l, v, position, id2);
        WifiNetwork selectedNetwork = (WifiNetwork)this.adapter.getItem(position);
        if (null != this.client) {
            this.client.onNetworkSelected(selectedNetwork);
        } else {
            log.e("Client was null");
        }
    }

    public Loader<Set<T>> onCreateLoader(int id2, Bundle args) {
        return this.client.createLoader(id2, args);
    }

    public void onLoadFinished(Loader<Set<T>> loader, Set<T> data) {
        log.d("new scan results: " + data);
        Set set = data = data == null ? Collections.emptySet() : data;
        if (!this.previousData.equals(data)) {
            this.previousData = data;
            this.adapter.clear();
            ArrayList<T> asList = new ArrayList<T>(data);
            Collections.sort(asList, (lhs, rhs) -> lhs.getSsid().compareTo(rhs.getSsid()));
            this.adapter.addAll(asList);
        }
        if (this.getListAdapter() == null) {
            this.setListAdapter((ListAdapter)this.adapter);
        }
        if (this.client != null) {
            this.client.onLoadFinished();
        }
    }

    public void onLoaderReset(Loader<Set<T>> loader) {
        this.adapter.clear();
    }

    public void startAggroLoading() {
        if (this.aggroLoadingRunnable == null) {
            this.scheduleNextAggroLoad();
        }
    }

    private void scheduleNextAggroLoad() {
        if (this.client == null) {
            this.stopAggroLoading();
            return;
        }
        this.aggroLoadingRunnable = () -> {
            log.d("Running aggro loading");
            this.scanAsync();
            this.aggroLoadingRunnable = null;
            this.scheduleNextAggroLoad();
        };
        this.aggroLoadingHandler.postDelayed(this.aggroLoadingRunnable, (long)this.client.getAggroLoadingTimeMillis());
    }

    public void stopAggroLoading() {
        if (this.aggroLoadingRunnable != null) {
            this.aggroLoadingHandler.removeCallbacks(this.aggroLoadingRunnable);
            this.aggroLoadingRunnable = null;
        }
    }

    private class WifiNetworkAdapter
    extends ArrayAdapter<T> {
        WifiNetworkAdapter(Context context) {
            super(context, 17367043);
        }

        @NonNull
        public View getView(int position, View convertView, @NonNull ViewGroup parent) {
            WifiNetwork wifiNetwork;
            if (convertView == null) {
                convertView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.row_wifi_scan_result, parent, false);
                ImageView theWifi = (ImageView)Ui.findView(convertView, R.id.the_wifi);
                Drawable whiteWifi = Ui.getTintedDrawable(this.getContext(), R.drawable.the_wifi, R.color.element_tint_color);
                theWifi.setImageDrawable(whiteWifi);
                ImageView securityIcon = (ImageView)Ui.findView(convertView, R.id.wifi_security_indicator_icon);
                Drawable whiteLock = Ui.getTintedDrawable(this.getContext(), R.drawable.lock, R.color.element_tint_color);
                securityIcon.setImageDrawable(whiteLock);
            }
            if ((wifiNetwork = (WifiNetwork)this.getItem(position)) != null) {
                Ui.setText(convertView, 16908308, (CharSequence)wifiNetwork.getSsid().toString());
                Ui.findView(convertView, R.id.wifi_security_indicator_icon).setVisibility(wifiNetwork.isSecured() ? 0 : 8);
            }
            return convertView;
        }
    }

    public static interface Client<T extends WifiNetwork> {
        public void onNetworkSelected(T var1);

        public Loader<Set<T>> createLoader(int var1, Bundle var2);

        public void onLoadFinished();

        public String getListEmptyText();

        public int getAggroLoadingTimeMillis();
    }
}

