/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.Loader;
import android.support.v7.app.AlertDialog;
import android.view.View;
import butterknife.ButterKnife;
import butterknife.OnClick;
import io.particle.android.sdk.devicesetup.ParticleDeviceSetupLibrary;
import io.particle.android.sdk.devicesetup.R;
import io.particle.android.sdk.devicesetup.commands.CommandClient;
import io.particle.android.sdk.devicesetup.commands.CommandClientFactory;
import io.particle.android.sdk.devicesetup.commands.data.WifiSecurity;
import io.particle.android.sdk.devicesetup.loaders.ScanApCommandLoader;
import io.particle.android.sdk.devicesetup.model.ScanAPCommandResult;
import io.particle.android.sdk.devicesetup.ui.ConnectingActivity;
import io.particle.android.sdk.devicesetup.ui.ManualNetworkEntryActivity;
import io.particle.android.sdk.devicesetup.ui.PasswordEntryActivity;
import io.particle.android.sdk.devicesetup.ui.RequiresWifiScansActivity;
import io.particle.android.sdk.devicesetup.ui.WifiListFragment;
import io.particle.android.sdk.di.ApModule;
import io.particle.android.sdk.utils.SEGAnalytics;
import io.particle.android.sdk.utils.SSID;
import io.particle.android.sdk.utils.WifiFacade;
import io.particle.android.sdk.utils.ui.ParticleUi;
import io.particle.android.sdk.utils.ui.Ui;
import java.util.Set;
import javax.inject.Inject;

public class SelectNetworkActivity
extends RequiresWifiScansActivity
implements WifiListFragment.Client<ScanAPCommandResult> {
    private static final String EXTRA_SOFT_AP = "EXTRA_SOFT_AP";
    private WifiListFragment wifiListFragment;
    @Inject
    protected WifiFacade wifiFacade;
    @Inject
    protected CommandClientFactory commandClientFactory;
    private SSID softApSSID;

    public static Intent buildIntent(Context ctx, SSID deviceSoftAP) {
        return new Intent(ctx, SelectNetworkActivity.class).putExtra(EXTRA_SOFT_AP, (Parcelable)deviceSoftAP);
    }

    @OnClick(value={2131492895})
    protected void onRescanClick() {
        ParticleUi.showParticleButtonProgress((FragmentActivity)this, R.id.action_rescan, true);
        this.wifiListFragment.scanAsync();
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ParticleDeviceSetupLibrary.getInstance().getApplicationComponent().activityComponentBuilder().apModule(new ApModule()).build().inject(this);
        SEGAnalytics.screen("Device Setup: Select Network Screen");
        this.softApSSID = (SSID)this.getIntent().getParcelableExtra(EXTRA_SOFT_AP);
        this.setContentView(R.layout.activity_select_network);
        ButterKnife.bind((Activity)this);
        this.wifiListFragment = (WifiListFragment)((Object)Ui.findFrag((FragmentActivity)this, R.id.wifi_list_fragment));
    }

    public void onManualNetworkEntryClicked(View view) {
        this.startActivity(ManualNetworkEntryActivity.buildIntent((Context)this, this.softApSSID));
        this.finish();
    }

    @Override
    public void onNetworkSelected(ScanAPCommandResult selectedNetwork) {
        if (WifiSecurity.isEnterpriseNetwork(selectedNetwork.scan.wifiSecurityType)) {
            new AlertDialog.Builder((Context)this).setMessage((CharSequence)this.getString(R.string.enterprise_networks_not_supported)).setPositiveButton(R.string.ok, (dialog, which) -> dialog.dismiss()).show();
            return;
        }
        this.wifiListFragment.stopAggroLoading();
        if (selectedNetwork.isSecured()) {
            SEGAnalytics.track("Device Setup: Selected secured network");
            this.startActivity(PasswordEntryActivity.buildIntent((Context)this, this.softApSSID, selectedNetwork.scan));
        } else {
            SEGAnalytics.track("Device Setup: Selected open network");
            SSID softApSSID = this.wifiFacade.getCurrentlyConnectedSSID();
            this.startActivity(ConnectingActivity.buildIntent((Context)this, softApSSID, selectedNetwork.scan));
        }
        this.finish();
    }

    @Override
    public Loader<Set<ScanAPCommandResult>> createLoader(int id2, Bundle args) {
        CommandClient client = this.commandClientFactory.newClientUsingDefaultsForDevices(this.wifiFacade, this.softApSSID);
        return new ScanApCommandLoader((Context)this, client);
    }

    @Override
    public void onLoadFinished() {
        ParticleUi.showParticleButtonProgress((FragmentActivity)this, R.id.action_rescan, false);
    }

    @Override
    public String getListEmptyText() {
        return this.getString(R.string.no_wifi_networks_found);
    }

    @Override
    public int getAggroLoadingTimeMillis() {
        return 10000;
    }
}

