/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.ui;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import io.particle.android.sdk.cloud.ParticleCloud;
import io.particle.android.sdk.cloud.ParticleDevice;
import io.particle.android.sdk.devicesetup.ParticleDeviceSetupLibrary;
import io.particle.android.sdk.devicesetup.R;
import io.particle.android.sdk.devicesetup.SetupProcessException;
import io.particle.android.sdk.devicesetup.setupsteps.SetupStep;
import io.particle.android.sdk.devicesetup.setupsteps.SetupStepsRunnerTask;
import io.particle.android.sdk.devicesetup.setupsteps.StepProgress;
import io.particle.android.sdk.devicesetup.ui.DeviceSetupState;
import io.particle.android.sdk.devicesetup.ui.SuccessActivity;
import io.particle.android.sdk.utils.CoreNameGenerator;
import io.particle.android.sdk.utils.EZ;
import io.particle.android.sdk.utils.Funcy;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.TLog;
import io.particle.android.sdk.utils.ui.Ui;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;

public class ConnectingProcessWorkerTask
extends SetupStepsRunnerTask {
    private static final TLog log = TLog.get(ConnectingProcessWorkerTask.class);
    @Inject
    protected ParticleCloud sparkCloud;
    private WeakReference<Activity> activityReference;
    private String deviceId;
    private Drawable tintedSpinner;
    private Drawable tintedCheckmark;

    ConnectingProcessWorkerTask(Activity activity, List<SetupStep> steps, int maxOverallAttempts) {
        super(steps, maxOverallAttempts);
        ParticleDeviceSetupLibrary.getInstance().getApplicationComponent().activityComponentBuilder().build().inject(this);
        this.deviceId = DeviceSetupState.deviceToBeSetUpId;
        this.activityReference = new WeakReference<Activity>(activity);
        this.tintedSpinner = Ui.getTintedDrawable((Context)activity, R.drawable.progress_spinner, R.color.element_tint_color);
        this.tintedCheckmark = Ui.getTintedDrawable((Context)activity, R.drawable.checkmark, R.color.element_tint_color);
    }

    protected void onProgressUpdate(StepProgress ... values) {
        Activity activity = (Activity)this.activityReference.get();
        if (activity == null) {
            return;
        }
        for (StepProgress progress : values) {
            View v = activity.findViewById(progress.stepId);
            if (v == null) continue;
            this.updateProgress(progress, v);
        }
    }

    protected void onPostExecute(SetupProcessException error) {
        int resultCode;
        if (error != null) {
            resultCode = error.failedStep.getStepConfig().resultCode;
        } else {
            log.d("HUZZAH, VICTORY!");
            resultCode = 1;
            EZ.runAsync(() -> {
                try {
                    Py.PySet names = Py.set((Collection)Funcy.transformList((List)this.sparkCloud.getDevices(), (Funcy.Predicate)Funcy.notNull(), ParticleDevice::getName, Py::truthy));
                    ParticleDevice device = this.sparkCloud.getDevice(this.deviceId);
                    if (device != null && !Py.truthy((Object)device.getName())) {
                        device.setName(CoreNameGenerator.generateUniqueName((Set<String>)names));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        Activity activity = (Activity)this.activityReference.get();
        if (activity != null) {
            activity.startActivity(SuccessActivity.buildIntent((Context)activity, resultCode, this.deviceId));
            activity.finish();
        }
    }

    private void updateProgress(StepProgress progress, View progressStepContainer) {
        ProgressBar progBar = (ProgressBar)Ui.findView(progressStepContainer, R.id.spinner);
        ImageView checkmark = (ImageView)Ui.findView(progressStepContainer, R.id.checkbox);
        if (checkmark.getVisibility() == 0) {
            return;
        }
        progressStepContainer.setVisibility(0);
        if (progress.status == 1) {
            checkmark.setVisibility(8);
            progBar.setProgressDrawable(this.tintedSpinner);
            progBar.setVisibility(0);
        } else {
            progBar.setVisibility(8);
            checkmark.setImageDrawable(this.tintedCheckmark);
            checkmark.setVisibility(0);
        }
    }
}

