/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.support.v4.app.FragmentActivity;
import butterknife.ButterKnife;
import butterknife.OnClick;
import com.google.gson.Gson;
import com.squareup.phrase.Phrase;
import io.particle.android.sdk.cloud.ParticleCloud;
import io.particle.android.sdk.devicesetup.ApConnector;
import io.particle.android.sdk.devicesetup.ParticleDeviceSetupLibrary;
import io.particle.android.sdk.devicesetup.R;
import io.particle.android.sdk.devicesetup.commands.CommandClient;
import io.particle.android.sdk.devicesetup.commands.CommandClientFactory;
import io.particle.android.sdk.devicesetup.commands.ScanApCommand;
import io.particle.android.sdk.devicesetup.setupsteps.CheckIfDeviceClaimedStep;
import io.particle.android.sdk.devicesetup.setupsteps.ConfigureAPStep;
import io.particle.android.sdk.devicesetup.setupsteps.ConnectDeviceToNetworkStep;
import io.particle.android.sdk.devicesetup.setupsteps.EnsureSoftApNotVisible;
import io.particle.android.sdk.devicesetup.setupsteps.SetupStep;
import io.particle.android.sdk.devicesetup.setupsteps.SetupStepApReconnector;
import io.particle.android.sdk.devicesetup.setupsteps.SetupStepsFactory;
import io.particle.android.sdk.devicesetup.setupsteps.WaitForCloudConnectivityStep;
import io.particle.android.sdk.devicesetup.setupsteps.WaitForDisconnectionFromDeviceStep;
import io.particle.android.sdk.devicesetup.ui.ConnectingProcessWorkerTask;
import io.particle.android.sdk.devicesetup.ui.DeviceSetupState;
import io.particle.android.sdk.devicesetup.ui.RequiresWifiScansActivity;
import io.particle.android.sdk.di.ApModule;
import io.particle.android.sdk.ui.BaseActivity;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.SEGAnalytics;
import io.particle.android.sdk.utils.SSID;
import io.particle.android.sdk.utils.SoftAPConfigRemover;
import io.particle.android.sdk.utils.TLog;
import io.particle.android.sdk.utils.WifiFacade;
import io.particle.android.sdk.utils.ui.Ui;
import java.security.PublicKey;
import java.util.List;
import javax.inject.Inject;

public class ConnectingActivity
extends RequiresWifiScansActivity {
    public static final String EXTRA_NETWORK_TO_CONFIGURE = "EXTRA_NETWORK_TO_CONFIGURE";
    public static final String EXTRA_NETWORK_SECRET = "EXTRA_NETWORK_SECRET";
    public static final String EXTRA_SOFT_AP_SSID = "EXTRA_SOFT_AP_SSID";
    private static final TLog log = TLog.get(ConnectingActivity.class);
    private ConnectingProcessWorkerTask connectingProcessWorkerTask;
    @Inject
    protected SoftAPConfigRemover softAPConfigRemover;
    @Inject
    protected WifiFacade wifiFacade;
    @Inject
    protected ApConnector apConnector;
    @Inject
    protected CommandClientFactory commandClientFactory;
    @Inject
    protected SetupStepsFactory setupStepsFactory;
    private ScanApCommand.Scan networkToConnectTo;
    private String networkSecretPlaintext;
    private PublicKey publicKey;
    private SSID deviceSoftApSsid;
    @Inject
    protected ParticleCloud sparkCloud;
    @Inject
    protected Gson gson;

    public static Intent buildIntent(Context ctx, SSID deviceSoftApSsid, ScanApCommand.Scan networkToConnectTo) {
        return new Intent(ctx, ConnectingActivity.class).putExtra(EXTRA_NETWORK_TO_CONFIGURE, ParticleDeviceSetupLibrary.getInstance().getApplicationComponent().getGson().toJson((Object)networkToConnectTo)).putExtra(EXTRA_SOFT_AP_SSID, (Parcelable)deviceSoftApSsid);
    }

    public static Intent buildIntent(Context ctx, SSID deviceSoftApSsid, ScanApCommand.Scan networkToConnectTo, String secret) {
        return ConnectingActivity.buildIntent(ctx, deviceSoftApSsid, networkToConnectTo).putExtra(EXTRA_NETWORK_SECRET, secret);
    }

    @OnClick(value={2131492873})
    protected void onCancelClick() {
        if (this.connectingProcessWorkerTask != null && !this.connectingProcessWorkerTask.isCancelled()) {
            this.connectingProcessWorkerTask.cancel(false);
        }
        this.finish();
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_connecting);
        ParticleDeviceSetupLibrary.getInstance().getApplicationComponent().activityComponentBuilder().apModule(new ApModule()).build().inject(this);
        ButterKnife.bind((Activity)this);
        SEGAnalytics.screen("Device Setup: Connecting progress screen");
        this.publicKey = DeviceSetupState.publicKey;
        this.deviceSoftApSsid = (SSID)this.getIntent().getParcelableExtra(EXTRA_SOFT_AP_SSID);
        String asJson = this.getIntent().getStringExtra(EXTRA_NETWORK_TO_CONFIGURE);
        this.networkToConnectTo = (ScanApCommand.Scan)this.gson.fromJson(asJson, ScanApCommand.Scan.class);
        this.networkSecretPlaintext = this.getIntent().getStringExtra(EXTRA_NETWORK_SECRET);
        log.d("Connecting to " + this.networkToConnectTo + ", with networkSecretPlaintext of size: " + (this.networkSecretPlaintext == null ? 0 : this.networkSecretPlaintext.length()));
        Ui.setText((FragmentActivity)this, R.id.network_name, (CharSequence)this.networkToConnectTo.ssid);
        Ui.setText((FragmentActivity)this, R.id.connecting_text, Phrase.from((Context)this, (int)R.string.connecting_text).put("device_name", (CharSequence)this.getString(R.string.device_name)).format());
        Ui.setText((FragmentActivity)this, R.id.network_name, (CharSequence)this.networkToConnectTo.ssid);
        this.connectingProcessWorkerTask = new ConnectingProcessWorkerTask((Activity)this, this.buildSteps(), 15);
        this.connectingProcessWorkerTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    protected void onStop() {
        super.onStop();
        if (this.connectingProcessWorkerTask != null && !this.connectingProcessWorkerTask.isCancelled()) {
            this.connectingProcessWorkerTask.cancel(true);
            this.connectingProcessWorkerTask = null;
        }
        this.apConnector.stop();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.softAPConfigRemover.removeAllSoftApConfigs();
        this.softAPConfigRemover.reenableWifiNetworks();
    }

    private List<SetupStep> buildSteps() {
        CommandClient commandClient = this.commandClientFactory.newClientUsingDefaultsForDevices(this.wifiFacade, this.deviceSoftApSsid);
        SetupStepApReconnector reconnector = new SetupStepApReconnector(this.wifiFacade, this.apConnector, new Handler(), this.deviceSoftApSsid);
        ConfigureAPStep configureAPStep = this.setupStepsFactory.newConfigureApStep(commandClient, reconnector, this.networkToConnectTo, this.networkSecretPlaintext, this.publicKey);
        ConnectDeviceToNetworkStep connectDeviceToNetworkStep = this.setupStepsFactory.newConnectDeviceToNetworkStep(commandClient, reconnector);
        WaitForDisconnectionFromDeviceStep waitForDisconnectionFromDeviceStep = this.setupStepsFactory.newWaitForDisconnectionFromDeviceStep(this.deviceSoftApSsid, this.wifiFacade);
        EnsureSoftApNotVisible ensureSoftApNotVisible = this.setupStepsFactory.newEnsureSoftApNotVisible(this.deviceSoftApSsid, this.wifiFacade);
        WaitForCloudConnectivityStep waitForLocalCloudConnectivityStep = this.setupStepsFactory.newWaitForCloudConnectivityStep(this.getApplicationContext());
        CheckIfDeviceClaimedStep checkIfDeviceClaimedStep = this.setupStepsFactory.newCheckIfDeviceClaimedStep(this.sparkCloud, DeviceSetupState.deviceToBeSetUpId);
        List steps = Py.list((Object[])new SetupStep[]{configureAPStep, connectDeviceToNetworkStep, waitForDisconnectionFromDeviceStep, ensureSoftApNotVisible, waitForLocalCloudConnectivityStep});
        if (!BaseActivity.setupOnly) {
            steps.add(checkIfDeviceClaimedStep);
        }
        return steps;
    }
}

