/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.setupsteps;

import android.os.AsyncTask;
import io.particle.android.sdk.devicesetup.SetupProcessException;
import io.particle.android.sdk.devicesetup.setupsteps.SetupStep;
import io.particle.android.sdk.devicesetup.setupsteps.SetupStepException;
import io.particle.android.sdk.devicesetup.setupsteps.StepProgress;
import io.particle.android.sdk.utils.EZ;
import io.particle.android.sdk.utils.TLog;
import java.util.List;

public abstract class SetupStepsRunnerTask
extends AsyncTask<Void, StepProgress, SetupProcessException> {
    private final TLog log = TLog.get(((Object)((Object)this)).getClass());
    private final List<SetupStep> steps;
    private final int maxOverallAttempts;

    public SetupStepsRunnerTask(List<SetupStep> steps, int maxOverallAttempts) {
        this.steps = steps;
        this.maxOverallAttempts = maxOverallAttempts;
    }

    public SetupProcessException doInBackground(Void ... voids) {
        for (int attempts = 0; attempts < this.maxOverallAttempts; ++attempts) {
            try {
                this.runSteps();
                return null;
            }
            catch (SetupStepException e) {
                this.log.w("Setup step failed: " + e.getMessage());
                continue;
            }
            catch (SetupProcessException e) {
                return e;
            }
        }
        return new SetupProcessException("(Unknown setup error)", null);
    }

    private void runSteps() throws SetupStepException, SetupProcessException {
        for (SetupStep step : this.steps) {
            this.throwIfCancelled();
            this.publishProgress(new StepProgress[]{new StepProgress(step.getStepConfig().getStepId(), 1)});
            try {
                EZ.threadSleep((long)1000L);
                this.throwIfCancelled();
                step.runStep();
            }
            catch (SetupStepException e) {
                EZ.threadSleep((long)2000L);
                throw e;
            }
            this.publishProgress(new StepProgress[]{new StepProgress(step.getStepConfig().getStepId(), 2)});
        }
    }

    private void throwIfCancelled() {
        if (this.isCancelled()) {
            throw new RuntimeException("Task was cancelled");
        }
    }
}

