/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.setupsteps;

import io.particle.android.sdk.devicesetup.SetupProcessException;
import io.particle.android.sdk.devicesetup.setupsteps.SetupStep;
import io.particle.android.sdk.devicesetup.setupsteps.SetupStepException;
import io.particle.android.sdk.devicesetup.setupsteps.StepConfig;
import io.particle.android.sdk.utils.EZ;
import io.particle.android.sdk.utils.Funcy;
import io.particle.android.sdk.utils.Preconditions;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.SSID;
import io.particle.android.sdk.utils.WifiFacade;
import java.util.Collection;
import java.util.List;

public class EnsureSoftApNotVisible
extends SetupStep {
    private final WifiFacade wifiFacade;
    private final SSID softApName;
    private final Funcy.Predicate<SSID> matchesSoftApSSID;
    private boolean wasFulfilledOnce = false;

    EnsureSoftApNotVisible(StepConfig stepConfig, SSID softApSSID, WifiFacade wifiFacade) {
        super(stepConfig);
        Preconditions.checkNotNull((Object)softApSSID, (Object)"softApSSID cannot be null.");
        this.wifiFacade = wifiFacade;
        this.softApName = softApSSID;
        this.matchesSoftApSSID = this.softApName::equals;
    }

    @Override
    public boolean isStepFulfilled() {
        return this.wasFulfilledOnce && !this.isSoftApVisible();
    }

    @Override
    protected void onRunStep() throws SetupStepException, SetupProcessException {
        if (!this.wasFulfilledOnce) {
            this.onStepNeverYetFulfilled();
        } else {
            this.onStepPreviouslyFulfilled();
        }
    }

    private void onStepNeverYetFulfilled() throws SetupStepException {
        for (int i = 0; i < 16; ++i) {
            if (!this.isSoftApVisible()) {
                this.wasFulfilledOnce = true;
                return;
            }
            if (i % 6 == 0) {
                this.wifiFacade.startScan();
            }
            EZ.threadSleep((long)250L);
        }
        throw new SetupStepException("Wi-Fi credentials appear to be incorrect or an error has occurred");
    }

    private void onStepPreviouslyFulfilled() throws SetupProcessException {
        if (this.isSoftApVisible()) {
            throw new SetupProcessException("Soft AP visible again; Wi-Fi credentials may be incorrect", this);
        }
    }

    private boolean isSoftApVisible() {
        List scansPlusConnectedSsid = Py.list();
        SSID currentlyConnected = this.wifiFacade.getCurrentlyConnectedSSID();
        if (currentlyConnected != null) {
            scansPlusConnectedSsid.add(currentlyConnected);
        }
        scansPlusConnectedSsid.addAll(Funcy.transformList(this.wifiFacade.getScanResults(), (Funcy.Predicate)Funcy.notNull(), SSID::from));
        this.log.d("scansPlusConnectedSsid: " + scansPlusConnectedSsid);
        this.log.d("Soft AP we're looking for: " + this.softApName);
        SSID firstMatch = (SSID)Funcy.findFirstMatch((Collection)scansPlusConnectedSsid, this.matchesSoftApSSID);
        this.log.d("Matching SSID result: '" + firstMatch + "'");
        return firstMatch != null;
    }
}

