/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.utils.ui;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import io.particle.android.sdk.devicesetup.R;
import io.particle.android.sdk.utils.SEGAnalytics;
import io.particle.android.sdk.utils.ui.Ui;

public class WebViewActivity
extends AppCompatActivity {
    private static final String EXTRA_CONTENT_URI = "EXTRA_CONTENT_URI";
    private static final String EXTRA_PAGE_TITLE = "EXTRA_PAGE_TITLE";

    public static Intent buildIntent(Context ctx, Uri uri) {
        return new Intent(ctx, WebViewActivity.class).putExtra(EXTRA_CONTENT_URI, (Parcelable)uri);
    }

    public static Intent buildIntent(Context ctx, Uri uri, CharSequence pageTitle) {
        return WebViewActivity.buildIntent(ctx, uri).putExtra(EXTRA_PAGE_TITLE, pageTitle.toString());
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_web_view);
        SEGAnalytics.track("Device Setup: Webview Screen");
        Toolbar toolbar = (Toolbar)Ui.findView((FragmentActivity)this, R.id.toolbar);
        toolbar.setNavigationIcon(Ui.getTintedDrawable((Context)this, R.drawable.ic_clear_black_24dp, 17170443));
        toolbar.setNavigationOnClickListener(view -> this.finish());
        if (this.getIntent().hasExtra(EXTRA_PAGE_TITLE)) {
            toolbar.setTitle((CharSequence)this.getIntent().getStringExtra(EXTRA_PAGE_TITLE));
        }
        WebView webView = (WebView)Ui.findView((FragmentActivity)this, R.id.web_content);
        webView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                view.loadUrl(url);
                return false;
            }
        });
        WebSettings webSettings = webView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        Uri uri = (Uri)this.getIntent().getParcelableExtra(EXTRA_CONTENT_URI);
        webView.loadUrl(uri.toString());
    }
}

