/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import io.particle.android.sdk.utils.Funcy;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.SSID;
import io.particle.android.sdk.utils.TLog;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class WifiFacade {
    private static final TLog log = TLog.get(WifiFacade.class);
    public static Funcy.Predicate<ScanResult> is24Ghz = scanResult -> scanResult.frequency > 2300 && scanResult.frequency < 2500;
    public static Funcy.Predicate<ScanResult> isWifiNameTruthy = scanResult -> Py.truthy((Object)scanResult.SSID);
    private final WifiManager wifiManager;
    private final ConnectivityManager connectivityManager;

    public static WifiFacade get(Context ctx) {
        Context appCtx = ctx.getApplicationContext();
        return new WifiFacade((WifiManager)appCtx.getSystemService("wifi"), (ConnectivityManager)appCtx.getSystemService("connectivity"));
    }

    private WifiFacade(WifiManager wifiManager, ConnectivityManager connectivityManager) {
        this.wifiManager = wifiManager;
        this.connectivityManager = connectivityManager;
    }

    public int getIdForConfiguredNetwork(SSID ssid) {
        WifiConfiguration configuredNetwork = (WifiConfiguration)Funcy.findFirstMatch(this.getConfiguredNetworks(), wifiConfiguration -> SSID.from(wifiConfiguration).equals(ssid));
        if (configuredNetwork == null) {
            log.d("No network found (returning -1) for SSID: " + ssid);
            return -1;
        }
        return configuredNetwork.networkId;
    }

    public boolean reenableNetwork(SSID ssid) {
        int networkId = this.getIdForConfiguredNetwork(ssid);
        if (networkId == -1) {
            log.w("reenableNetwork(): no network found for SSID?? " + ssid);
            return false;
        }
        log.d("Reenabling network configuration for:" + ssid);
        return this.wifiManager.enableNetwork(networkId, false);
    }

    public boolean removeNetwork(SSID ssid) {
        int networkId = this.getIdForConfiguredNetwork(ssid);
        if (networkId == -1) {
            log.w("No network found for SSID " + ssid);
            return false;
        }
        log.d("Removing network configuration for:" + ssid);
        return this.removeNetwork(networkId);
    }

    @Nullable
    public SSID getCurrentlyConnectedSSID() {
        WifiInfo connectionInfo = this.getConnectionInfo();
        if (connectionInfo == null) {
            log.w("getCurrentlyConnectedSSID(): WifiManager.getConnectionInfo() returned null");
            return null;
        }
        SSID ssid = SSID.from(connectionInfo);
        log.d("Currently connected to: " + ssid + ", supplicant state: " + connectionInfo.getSupplicantState());
        return ssid;
    }

    @Nullable
    @RequiresApi(api=21)
    public Network getNetworkForSSID(SSID ssid) {
        return (Network)Funcy.findFirstMatch(Arrays.asList(this.connectivityManager.getAllNetworks()), network -> {
            NetworkInfo networkInfo = this.connectivityManager.getNetworkInfo(network);
            return Py.truthy((Object)networkInfo.getExtraInfo()) && SSID.from(networkInfo.getExtraInfo()).equals(ssid);
        });
    }

    public int addNetwork(WifiConfiguration config) {
        log.d("addNetwork with SSID " + config.SSID + ": " + config);
        return this.wifiManager.addNetwork(config);
    }

    public boolean disconnect() {
        log.d("disconnect()");
        return this.wifiManager.disconnect();
    }

    public boolean enableNetwork(int networkId, boolean disableOthers) {
        log.d("enableNetwork for networkID " + networkId);
        return this.wifiManager.enableNetwork(networkId, disableOthers);
    }

    public WifiConfiguration getWifiConfiguration(SSID ssid) {
        List<WifiConfiguration> wifiConfigurations = this.getConfiguredNetworks();
        for (WifiConfiguration configuration : wifiConfigurations) {
            log.d("Found configured wifi: " + configuration.SSID);
            if (!configuration.SSID.equals(ssid.inQuotes())) continue;
            return configuration;
        }
        return null;
    }

    @Nullable
    public WifiInfo getConnectionInfo() {
        return this.wifiManager.getConnectionInfo();
    }

    public List<ScanResult> getScanResults() {
        List results = this.wifiManager.getScanResults();
        return results == null ? Collections.emptyList() : results;
    }

    public boolean isWifiEnabled() {
        return this.wifiManager.isWifiEnabled();
    }

    public void reassociate() {
        log.d("reassociate");
        this.wifiManager.reassociate();
    }

    public boolean reconnect() {
        log.d("reconnect");
        return this.wifiManager.reconnect();
    }

    public boolean removeNetwork(int networkId) {
        log.d("Removing network configuration for networkId: " + networkId);
        return this.wifiManager.removeNetwork(networkId);
    }

    public boolean setWifiEnabled(boolean enabled) {
        log.d("setWifiEnabled: " + enabled);
        return this.wifiManager.setWifiEnabled(enabled);
    }

    public boolean startScan() {
        log.d("startScan()");
        return this.wifiManager.startScan();
    }

    private List<WifiConfiguration> getConfiguredNetworks() {
        List configuredNetworks = this.wifiManager.getConfiguredNetworks();
        return configuredNetworks == null ? Collections.emptyList() : configuredNetworks;
    }
}

