/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.view.View;
import android.widget.CheckBox;
import butterknife.ButterKnife;
import butterknife.OnCheckedChanged;
import io.particle.android.sdk.devicesetup.ParticleDeviceSetupLibrary;
import io.particle.android.sdk.devicesetup.R;
import io.particle.android.sdk.devicesetup.commands.CommandClientFactory;
import io.particle.android.sdk.devicesetup.commands.ScanApCommand;
import io.particle.android.sdk.devicesetup.commands.data.WifiSecurity;
import io.particle.android.sdk.devicesetup.loaders.ScanApCommandLoader;
import io.particle.android.sdk.devicesetup.model.ScanAPCommandResult;
import io.particle.android.sdk.devicesetup.ui.ConnectingActivity;
import io.particle.android.sdk.devicesetup.ui.PasswordEntryActivity;
import io.particle.android.sdk.di.ApModule;
import io.particle.android.sdk.ui.BaseActivity;
import io.particle.android.sdk.utils.SEGAnalytics;
import io.particle.android.sdk.utils.SSID;
import io.particle.android.sdk.utils.WifiFacade;
import io.particle.android.sdk.utils.ui.ParticleUi;
import io.particle.android.sdk.utils.ui.Ui;
import java.util.Set;
import javax.inject.Inject;

public class ManualNetworkEntryActivity
extends BaseActivity
implements LoaderManager.LoaderCallbacks<Set<ScanAPCommandResult>> {
    private static final String EXTRA_SOFT_AP = "EXTRA_SOFT_AP";
    @Inject
    protected WifiFacade wifiFacade;
    @Inject
    protected CommandClientFactory commandClientFactory;
    private SSID softApSSID;
    protected Integer wifiSecurityType = WifiSecurity.WPA2_AES_PSK.asInt();

    public static Intent buildIntent(Context ctx, SSID softApSSID) {
        return new Intent(ctx, ManualNetworkEntryActivity.class).putExtra(EXTRA_SOFT_AP, (Parcelable)softApSSID);
    }

    @OnCheckedChanged(value={2131492974})
    protected void onSecureCheckedChange(boolean isChecked) {
        if (isChecked) {
            SEGAnalytics.track("Device Setup: Selected secured network");
            this.wifiSecurityType = WifiSecurity.WPA2_AES_PSK.asInt();
        } else {
            SEGAnalytics.track("Device Setup: Selected open network");
            this.wifiSecurityType = WifiSecurity.OPEN.asInt();
        }
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ParticleDeviceSetupLibrary.getInstance().getApplicationComponent().activityComponentBuilder().apModule(new ApModule()).build().inject(this);
        SEGAnalytics.screen("Device Setup: Manual network entry screen");
        this.softApSSID = (SSID)this.getIntent().getParcelableExtra(EXTRA_SOFT_AP);
        this.setContentView(R.layout.activity_manual_network_entry);
        ButterKnife.bind((Activity)this);
        ParticleUi.enableBrandLogoInverseVisibilityAgainstSoftKeyboard((FragmentActivity)this);
    }

    public void onConnectClicked(View view) {
        String ssid = Ui.getText((FragmentActivity)this, R.id.network_name, true);
        ScanApCommand.Scan scan = new ScanApCommand.Scan(ssid, this.wifiSecurityType, 0);
        CheckBox requiresPassword = (CheckBox)Ui.findView((FragmentActivity)this, R.id.network_requires_password);
        if (requiresPassword.isChecked()) {
            this.startActivity(PasswordEntryActivity.buildIntent((Context)this, this.softApSSID, scan));
        } else {
            this.startActivity(ConnectingActivity.buildIntent((Context)this, this.softApSSID, scan));
        }
    }

    public void onCancelClicked(View view) {
        this.finish();
    }

    public Loader<Set<ScanAPCommandResult>> onCreateLoader(int id2, Bundle args) {
        return new ScanApCommandLoader((Context)this, this.commandClientFactory.newClientUsingDefaultsForDevices(this.wifiFacade, this.softApSSID));
    }

    public void onLoadFinished(Loader<Set<ScanAPCommandResult>> loader, Set<ScanAPCommandResult> data) {
    }

    public void onLoaderReset(Loader<Set<ScanAPCommandResult>> loader) {
    }
}

