/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.ui;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AlertDialog;
import android.view.View;
import com.squareup.phrase.Phrase;
import io.particle.android.sdk.accountsetup.LoginActivity;
import io.particle.android.sdk.cloud.ParticleCloud;
import io.particle.android.sdk.cloud.ParticleCloudException;
import io.particle.android.sdk.cloud.Responses;
import io.particle.android.sdk.devicesetup.ParticleDeviceSetupLibrary;
import io.particle.android.sdk.devicesetup.R;
import io.particle.android.sdk.devicesetup.ui.DeviceSetupState;
import io.particle.android.sdk.devicesetup.ui.DiscoverDeviceActivity;
import io.particle.android.sdk.devicesetup.ui.PermissionsFragment;
import io.particle.android.sdk.di.ApModule;
import io.particle.android.sdk.ui.BaseActivity;
import io.particle.android.sdk.utils.Async;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.SEGAnalytics;
import io.particle.android.sdk.utils.SoftAPConfigRemover;
import io.particle.android.sdk.utils.TLog;
import io.particle.android.sdk.utils.ui.ParticleUi;
import io.particle.android.sdk.utils.ui.Toaster;
import io.particle.android.sdk.utils.ui.Ui;
import io.particle.android.sdk.utils.ui.WebViewActivity;
import java.util.Arrays;
import javax.inject.Inject;

public class GetReadyActivity
extends BaseActivity
implements PermissionsFragment.Client {
    private static final TLog log = TLog.get(GetReadyActivity.class);
    @Inject
    protected ParticleCloud sparkCloud;
    @Inject
    protected SoftAPConfigRemover softAPConfigRemover;
    private Async.AsyncApiWorker<ParticleCloud, Responses.ClaimCodeResponse> claimCodeWorker;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_get_ready);
        ParticleDeviceSetupLibrary.getInstance().getApplicationComponent().activityComponentBuilder().apModule(new ApModule()).build().inject(this);
        SEGAnalytics.screen("Device Setup: Get ready screen");
        this.softAPConfigRemover.removeAllSoftApConfigs();
        this.softAPConfigRemover.reenableWifiNetworks();
        PermissionsFragment.ensureAttached(this);
        Ui.findView((FragmentActivity)this, R.id.action_im_ready).setOnClickListener(this::onReadyButtonClicked);
        Ui.setTextFromHtml((FragmentActivity)this, R.id.action_troubleshooting, R.string.troubleshooting).setOnClickListener(v -> {
            Uri uri = Uri.parse((String)v.getContext().getString(R.string.troubleshooting_uri));
            this.startActivity(WebViewActivity.buildIntent(v.getContext(), uri));
        });
        Ui.setText((FragmentActivity)this, R.id.get_ready_text, Phrase.from((Context)this, (int)R.string.get_ready_text).put("device_name", (CharSequence)this.getString(R.string.device_name)).put("indicator_light_setup_color_name", (CharSequence)this.getString(R.string.listen_mode_led_color_name)).put("setup_button_identifier", (CharSequence)this.getString(R.string.mode_button_name)).format());
        Ui.setText((FragmentActivity)this, R.id.get_ready_text_title, Phrase.from((Context)this, (int)R.string.get_ready_title_text).put("device_name", (CharSequence)this.getString(R.string.device_name)).format());
    }

    protected void onStart() {
        super.onStart();
        this.softAPConfigRemover.removeAllSoftApConfigs();
        this.softAPConfigRemover.reenableWifiNetworks();
        if (this.sparkCloud.getAccessToken() == null && !BaseActivity.setupOnly) {
            this.startLoginActivity();
            this.finish();
        }
    }

    private void onReadyButtonClicked(View v) {
        if (this.claimCodeWorker != null && !this.claimCodeWorker.isCancelled()) {
            return;
        }
        DeviceSetupState.reset();
        if (BaseActivity.setupOnly) {
            this.moveToDeviceDiscovery();
            return;
        }
        this.showProgress(true);
        GetReadyActivity ctx = this;
        this.claimCodeWorker = Async.executeAsync((ParticleCloud)this.sparkCloud, (Async.ApiWork)new Async.ApiWork<ParticleCloud, Responses.ClaimCodeResponse>((Context)ctx){
            final /* synthetic */ Context val$ctx;
            {
                this.val$ctx = context;
            }

            public Responses.ClaimCodeResponse callApi(@NonNull ParticleCloud sparkCloud) throws ParticleCloudException {
                return GetReadyActivity.this.generateClaimCode(this.val$ctx);
            }

            public void onTaskFinished() {
                GetReadyActivity.this.claimCodeWorker = null;
                GetReadyActivity.this.showProgress(false);
            }

            public void onSuccess(@NonNull Responses.ClaimCodeResponse result) {
                GetReadyActivity.this.handleClaimCode(result);
            }

            public void onFailure(@NonNull ParticleCloudException error) {
                GetReadyActivity.this.onGenerateClaimCodeFail(error);
            }
        });
    }

    private void onGenerateClaimCodeFail(@NonNull ParticleCloudException error) {
        log.d("Generating claim code failed");
        ParticleCloudException.ResponseErrorData errorData = error.getResponseData();
        if (errorData != null && errorData.getHttpStatusCode() == 401) {
            this.onUnauthorizedError();
        } else {
            if (this.isFinishing()) {
                return;
            }
            String errorMsg = this.getString(R.string.get_ready_could_not_connect_to_cloud);
            if (error.getMessage() != null) {
                errorMsg = errorMsg + "\n\n" + error.getMessage();
            }
            new AlertDialog.Builder((Context)this).setTitle(R.string.error).setMessage((CharSequence)errorMsg).setPositiveButton(R.string.ok, (dialog, which) -> dialog.dismiss()).show();
        }
    }

    private void onUnauthorizedError() {
        if (this.isFinishing()) {
            this.sparkCloud.logOut();
            this.startLoginActivity();
            return;
        }
        String errorMsg = this.getString(R.string.get_ready_must_be_logged_in_as_customer, new Object[]{this.getString(R.string.brand_name)});
        new AlertDialog.Builder((Context)this).setTitle(R.string.access_denied).setMessage((CharSequence)errorMsg).setPositiveButton(R.string.ok, (dialog, which) -> {
            dialog.dismiss();
            log.i("Logging out user");
            this.sparkCloud.logOut();
            this.startLoginActivity();
            this.finish();
        }).show();
    }

    private void handleClaimCode(@NonNull Responses.ClaimCodeResponse result) {
        log.d("Claim code generated: " + result.claimCode);
        DeviceSetupState.claimCode = result.claimCode;
        if (Py.truthy((Object)result.deviceIds)) {
            DeviceSetupState.claimedDeviceIds.addAll(Arrays.asList(result.deviceIds));
        }
        if (this.isFinishing()) {
            return;
        }
        this.moveToDeviceDiscovery();
    }

    private Responses.ClaimCodeResponse generateClaimCode(Context ctx) throws ParticleCloudException {
        Resources res = ctx.getResources();
        if (res.getBoolean(R.bool.organization) && !res.getBoolean(R.bool.productMode)) {
            throw new ParticleCloudException(new Exception("Organization is deprecated, use productMode instead."));
        }
        if (res.getBoolean(R.bool.productMode)) {
            int productId = res.getInteger(R.integer.product_id);
            if (productId == 0) {
                throw new ParticleCloudException(new Exception("Product id must be set when productMode is in use."));
            }
            return this.sparkCloud.generateClaimCode(Integer.valueOf(productId));
        }
        return this.sparkCloud.generateClaimCode();
    }

    private void startLoginActivity() {
        this.startActivity(new Intent((Context)this, LoginActivity.class));
    }

    private void showProgress(boolean show) {
        ParticleUi.showParticleButtonProgress((FragmentActivity)this, R.id.action_im_ready, show);
    }

    private void moveToDeviceDiscovery() {
        if (PermissionsFragment.hasPermission((Context)this, "android.permission.ACCESS_COARSE_LOCATION")) {
            this.startActivity(new Intent((Context)this, DiscoverDeviceActivity.class));
        } else {
            PermissionsFragment.get(this).ensurePermission("android.permission.ACCESS_COARSE_LOCATION");
        }
    }

    @Override
    public void onUserAllowedPermission(String permission2) {
        this.moveToDeviceDiscovery();
    }

    @Override
    public void onUserDeniedPermission(String permission2) {
        Toaster.s((Context)this, this.getString(R.string.location_permission_denied_cannot_start_setup));
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        PermissionsFragment.get(this).onRequestPermissionsResult(requestCode, permissions, grantResults);
    }
}

