/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.ui;

import android.support.annotation.RestrictTo;
import io.particle.android.sdk.devicesetup.commands.CommandClient;
import io.particle.android.sdk.devicesetup.commands.DeviceIdCommand;
import io.particle.android.sdk.devicesetup.commands.PublicKeyCommand;
import io.particle.android.sdk.devicesetup.commands.SetCommand;
import io.particle.android.sdk.devicesetup.setupsteps.SetupStepException;
import io.particle.android.sdk.devicesetup.ui.DeviceSetupState;
import io.particle.android.sdk.devicesetup.ui.DiscoverDeviceActivity;
import io.particle.android.sdk.utils.Crypto;
import io.particle.android.sdk.utils.ParticleDeviceSetupInternalStringUtils;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.TLog;
import java.io.IOException;
import java.security.PublicKey;
import java.util.Locale;

public class DiscoverProcessWorker {
    private static final TLog log = TLog.get(DiscoverProcessWorker.class);
    private CommandClient client;
    private volatile String detectedDeviceID;
    volatile boolean isDetectedDeviceClaimed;
    volatile boolean gotOwnershipInfo;
    volatile boolean needToClaimDevice;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    DiscoverProcessWorker withClient(CommandClient client) {
        this.client = client;
        return this;
    }

    public void doTheThing() throws SetupStepException {
        if (!Py.truthy((Object)this.detectedDeviceID)) {
            try {
                DeviceIdCommand.Response response = this.client.sendCommand(new DeviceIdCommand(), DeviceIdCommand.Response.class);
                DeviceSetupState.deviceToBeSetUpId = this.detectedDeviceID = response.deviceIdHex.toLowerCase(Locale.ROOT);
                this.isDetectedDeviceClaimed = Py.truthy((Object)response.isClaimed);
            }
            catch (IOException e) {
                throw new SetupStepException("Process died while trying to get the device ID", e);
            }
        }
        if (DeviceSetupState.publicKey == null) {
            try {
                DeviceSetupState.publicKey = this.getPublicKey();
            }
            catch (Crypto.CryptoException e) {
                throw new SetupStepException("Unable to get public key: ", e);
            }
            catch (IOException e) {
                throw new SetupStepException("Error while fetching public key: ", e);
            }
        }
        if (!this.gotOwnershipInfo) {
            this.needToClaimDevice = false;
            if (!this.isDetectedDeviceClaimed) {
                this.setClaimCode();
                this.needToClaimDevice = true;
            } else {
                boolean deviceClaimedByUser = false;
                for (String deviceId : DeviceSetupState.claimedDeviceIds) {
                    if (!deviceId.equalsIgnoreCase(this.detectedDeviceID)) continue;
                    deviceClaimedByUser = true;
                    break;
                }
                this.gotOwnershipInfo = true;
                if (this.isDetectedDeviceClaimed && !deviceClaimedByUser) {
                    throw new DiscoverDeviceActivity.DeviceAlreadyClaimed("Device already claimed by another user");
                }
            }
        } else if (this.needToClaimDevice) {
            this.setClaimCode();
        }
    }

    private void setClaimCode() throws SetupStepException {
        try {
            log.d("Setting claim code using code: " + DeviceSetupState.claimCode);
            String claimCodeNoBackslashes = ParticleDeviceSetupInternalStringUtils.remove(DeviceSetupState.claimCode, "\\");
            SetCommand.Response response = this.client.sendCommand(new SetCommand("cc", claimCodeNoBackslashes), SetCommand.Response.class);
            if (Py.truthy((Object)response.responseCode)) {
                throw new SetupStepException("Received non-zero return code from set command: " + response.responseCode);
            }
            log.d("Successfully set claim code");
        }
        catch (IOException e) {
            throw new SetupStepException(e);
        }
    }

    private PublicKey getPublicKey() throws Crypto.CryptoException, IOException {
        PublicKeyCommand.Response response = this.client.sendCommand(new PublicKeyCommand(), PublicKeyCommand.Response.class);
        return Crypto.readPublicKeyFromHexEncodedDerString(response.publicKey);
    }
}

