/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.ui;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.location.LocationManager;
import android.net.Uri;
import android.net.wifi.WifiConfiguration;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.Loader;
import android.support.v7.app.AlertDialog;
import android.view.View;
import butterknife.ButterKnife;
import butterknife.OnClick;
import com.squareup.phrase.Phrase;
import io.particle.android.sdk.accountsetup.LoginActivity;
import io.particle.android.sdk.cloud.ParticleCloud;
import io.particle.android.sdk.devicesetup.ApConnector;
import io.particle.android.sdk.devicesetup.ParticleDeviceSetupLibrary;
import io.particle.android.sdk.devicesetup.R;
import io.particle.android.sdk.devicesetup.commands.CommandClientFactory;
import io.particle.android.sdk.devicesetup.loaders.WifiScanResultLoader;
import io.particle.android.sdk.devicesetup.model.ScanResultNetwork;
import io.particle.android.sdk.devicesetup.setupsteps.SetupStepException;
import io.particle.android.sdk.devicesetup.ui.ConnectToApFragment;
import io.particle.android.sdk.devicesetup.ui.DeviceSetupState;
import io.particle.android.sdk.devicesetup.ui.DiscoverProcessWorker;
import io.particle.android.sdk.devicesetup.ui.GetReadyActivity;
import io.particle.android.sdk.devicesetup.ui.RequiresWifiScansActivity;
import io.particle.android.sdk.devicesetup.ui.SelectNetworkActivity;
import io.particle.android.sdk.devicesetup.ui.WifiListFragment;
import io.particle.android.sdk.di.ApModule;
import io.particle.android.sdk.ui.BaseActivity;
import io.particle.android.sdk.utils.EZ;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.SEGAnalytics;
import io.particle.android.sdk.utils.SSID;
import io.particle.android.sdk.utils.SoftAPConfigRemover;
import io.particle.android.sdk.utils.TLog;
import io.particle.android.sdk.utils.WifiFacade;
import io.particle.android.sdk.utils.ui.Ui;
import io.particle.android.sdk.utils.ui.WebViewActivity;
import java.util.Set;
import javax.inject.Inject;

public class DiscoverDeviceActivity
extends RequiresWifiScansActivity
implements WifiListFragment.Client<ScanResultNetwork>,
ApConnector.Client {
    private static final int MAX_NUM_DISCOVER_PROCESS_ATTEMPTS = 5;
    private static final TLog log = TLog.get(DiscoverDeviceActivity.class);
    @Inject
    protected WifiFacade wifiFacade;
    @Inject
    protected ParticleCloud sparkCloud;
    @Inject
    protected DiscoverProcessWorker discoverProcessWorker;
    @Inject
    protected SoftAPConfigRemover softAPConfigRemover;
    @Inject
    protected CommandClientFactory commandClientFactory;
    private WifiListFragment wifiListFragment;
    private ProgressDialog connectToApSpinnerDialog;
    private AsyncTask<Void, Void, SetupStepException> connectToApTask;
    private boolean isResumed = false;
    private int discoverProcessAttempts = 0;
    private SSID selectedSoftApSSID;

    @OnClick(value={2131492898})
    protected void onTroubleshootingClick(View v) {
        Uri uri = Uri.parse((String)v.getContext().getString(R.string.troubleshooting_uri));
        this.startActivity(WebViewActivity.buildIntent(v.getContext(), uri));
    }

    @OnClick(value={2131492888})
    protected void onLogoutClick() {
        this.sparkCloud.logOut();
        log.i("logged out, username is: " + this.sparkCloud.getLoggedInUsername());
        this.startActivity(new Intent((Context)this, LoginActivity.class));
        this.finish();
    }

    @OnClick(value={2131492873})
    protected void onCancelClick() {
        this.finish();
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        ParticleDeviceSetupLibrary.getInstance().getApplicationComponent().activityComponentBuilder().apModule(new ApModule()).build().inject(this);
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_discover_device);
        ButterKnife.bind((Activity)this);
        SEGAnalytics.screen("Device Setup: Device discovery screen");
        this.softAPConfigRemover.removeAllSoftApConfigs();
        this.softAPConfigRemover.reenableWifiNetworks();
        DeviceSetupState.previouslyConnectedWifiNetwork = this.wifiFacade.getCurrentlyConnectedSSID();
        this.wifiListFragment = (WifiListFragment)((Object)Ui.findFrag((FragmentActivity)this, R.id.wifi_list_fragment));
        ConnectToApFragment.ensureAttached((FragmentActivity)this);
        this.resetWorker();
        Ui.setText((FragmentActivity)this, R.id.wifi_list_header, Phrase.from((Context)this, (int)R.string.wifi_list_header_text).put("device_name", (CharSequence)this.getString(R.string.device_name)).format());
        Ui.setText((FragmentActivity)this, R.id.msg_device_not_listed, Phrase.from((Context)this, (int)R.string.msg_device_not_listed).put("device_name", (CharSequence)this.getString(R.string.device_name)).put("setup_button_identifier", (CharSequence)this.getString(R.string.mode_button_name)).put("indicator_light", (CharSequence)this.getString(R.string.indicator_light)).put("indicator_light_setup_color_name", (CharSequence)this.getString(R.string.listen_mode_led_color_name)).format());
        Ui.setTextFromHtml((FragmentActivity)this, R.id.action_troubleshooting, R.string.troubleshooting);
        if (!Py.truthy((Object)this.sparkCloud.getLoggedInUsername())) {
            Ui.findView((FragmentActivity)this, R.id.logged_in_as).setVisibility(8);
        } else {
            Ui.setText((FragmentActivity)this, R.id.logged_in_as, Phrase.from((Context)this, (int)R.string.you_are_logged_in_as).put("username", (CharSequence)this.sparkCloud.getLoggedInUsername()).format());
        }
        Ui.findView((FragmentActivity)this, R.id.action_log_out).setVisibility(BaseActivity.setupOnly ? 8 : 0);
    }

    @Override
    protected void onStart() {
        super.onStart();
        if (!this.wifiFacade.isWifiEnabled()) {
            this.onWifiDisabled();
        }
        if (Build.VERSION.SDK_INT >= 23 && !this.canGetLocation()) {
            this.onLocationDisabled();
        }
    }

    protected void onResume() {
        super.onResume();
        this.isResumed = true;
    }

    protected void onPause() {
        super.onPause();
        this.isResumed = false;
    }

    private void resetWorker() {
        this.discoverProcessWorker.withClient(this.commandClientFactory.newClientUsingDefaultsForDevices(this.wifiFacade, this.selectedSoftApSSID));
    }

    private void onLocationDisabled() {
        log.d("Location disabled; prompting user");
        new AlertDialog.Builder((Context)this).setTitle(R.string.location_required).setMessage(R.string.location_required_message).setPositiveButton(R.string.enable_location, (dialog, which) -> {
            dialog.dismiss();
            log.i("Sending user to enabling Location services.");
            this.startActivity(new Intent("android.settings.LOCATION_SOURCE_SETTINGS"));
        }).setNegativeButton(R.string.exit_setup, (dialog, which) -> {
            dialog.dismiss();
            this.finish();
        }).show();
    }

    private boolean canGetLocation() {
        boolean gpsEnabled = false;
        boolean networkEnabled = false;
        LocationManager lm = (LocationManager)this.getSystemService("location");
        try {
            if (lm != null) {
                gpsEnabled = lm.isProviderEnabled("gps");
                networkEnabled = lm.isProviderEnabled("network");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return gpsEnabled || networkEnabled;
    }

    private void onWifiDisabled() {
        log.d("Wi-Fi disabled; prompting user");
        new AlertDialog.Builder((Context)this).setTitle(R.string.wifi_required).setPositiveButton(R.string.enable_wifi, (dialog, which) -> {
            dialog.dismiss();
            log.i("Enabling Wi-Fi at the user's request.");
            this.wifiFacade.setWifiEnabled(true);
            this.wifiListFragment.scanAsync();
        }).setNegativeButton(R.string.exit_setup, (dialog, which) -> {
            dialog.dismiss();
            this.finish();
        }).show();
    }

    @Override
    public void onNetworkSelected(ScanResultNetwork selectedNetwork) {
        WifiConfiguration wifiConfig = ApConnector.buildUnsecuredConfig(selectedNetwork.getSsid());
        this.selectedSoftApSSID = selectedNetwork.getSsid();
        this.resetWorker();
        this.connectToSoftAp(wifiConfig);
    }

    private void connectToSoftAp(WifiConfiguration config) {
        ++this.discoverProcessAttempts;
        this.softAPConfigRemover.onSoftApConfigured(SSID.from(config.SSID));
        ConnectToApFragment.get((FragmentActivity)this).connectToAP(config);
        this.showProgressDialog();
    }

    @Override
    public Loader<Set<ScanResultNetwork>> createLoader(int id2, Bundle args) {
        return new WifiScanResultLoader((Context)this, this.wifiFacade);
    }

    @Override
    public void onLoadFinished() {
    }

    @Override
    public String getListEmptyText() {
        return Phrase.from((Context)this, (int)R.string.empty_soft_ap_list_text).put("device_name", (CharSequence)this.getString(R.string.device_name)).format().toString();
    }

    @Override
    public int getAggroLoadingTimeMillis() {
        return 5000;
    }

    @Override
    public void onApConnectionSuccessful(WifiConfiguration config) {
        this.startConnectWorker();
    }

    @Override
    public void onApConnectionFailed(WifiConfiguration config) {
        this.hideProgressDialog();
        if (!this.canStartProcessAgain()) {
            this.onMaxAttemptsReached();
        } else {
            this.connectToSoftAp(config);
        }
    }

    private void showProgressDialog() {
        this.wifiListFragment.stopAggroLoading();
        String msg = Phrase.from((Context)this, (int)R.string.connecting_to_soft_ap).put("device_name", (CharSequence)this.getString(R.string.device_name)).format().toString();
        this.connectToApSpinnerDialog = new ProgressDialog((Context)this);
        this.connectToApSpinnerDialog.setMessage((CharSequence)msg);
        this.connectToApSpinnerDialog.setCancelable(false);
        this.connectToApSpinnerDialog.setIndeterminate(true);
        this.connectToApSpinnerDialog.show();
    }

    private void hideProgressDialog() {
        this.wifiListFragment.startAggroLoading();
        if (this.connectToApSpinnerDialog != null) {
            if (!this.isFinishing()) {
                this.connectToApSpinnerDialog.dismiss();
            }
            this.connectToApSpinnerDialog = null;
        }
    }

    @SuppressLint(value={"StaticFieldLeak"})
    private void startConnectWorker() {
        if (this.connectToApTask != null) {
            log.d("Already running connect worker " + this.connectToApTask + ", refusing to start another");
            return;
        }
        this.wifiListFragment.stopAggroLoading();
        if (!this.canStartProcessAgain()) {
            this.hideProgressDialog();
            this.onMaxAttemptsReached();
            return;
        }
        ++this.discoverProcessAttempts;
        this.connectToApTask = new AsyncTask<Void, Void, SetupStepException>(){

            protected SetupStepException doInBackground(Void ... voids) {
                try {
                    log.d("Waiting a couple seconds before trying the socket connection...");
                    EZ.threadSleep((long)2000L);
                    DiscoverDeviceActivity.this.discoverProcessWorker.doTheThing();
                    return null;
                }
                catch (SetupStepException e) {
                    log.d("Setup exception thrown: ", (Throwable)e);
                    return e;
                }
            }

            protected void onPostExecute(SetupStepException error) {
                DiscoverDeviceActivity.this.connectToApTask = null;
                if (error == null || BaseActivity.setupOnly && error instanceof DeviceAlreadyClaimed) {
                    DiscoverDeviceActivity.this.hideProgressDialog();
                    DiscoverDeviceActivity.this.startActivity(SelectNetworkActivity.buildIntent((Context)DiscoverDeviceActivity.this, DiscoverDeviceActivity.this.selectedSoftApSSID));
                    DiscoverDeviceActivity.this.finish();
                } else if (error instanceof DeviceAlreadyClaimed) {
                    DiscoverDeviceActivity.this.hideProgressDialog();
                    DiscoverDeviceActivity.this.onDeviceClaimedByOtherUser();
                } else {
                    DiscoverDeviceActivity.this.startConnectWorker();
                }
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
    }

    private boolean canStartProcessAgain() {
        return this.discoverProcessAttempts < 5;
    }

    private void onMaxAttemptsReached() {
        if (!this.isResumed) {
            this.finish();
            return;
        }
        String errorMsg = Phrase.from((Context)this, (int)R.string.unable_to_connect_to_soft_ap).put("device_name", (CharSequence)this.getString(R.string.device_name)).format().toString();
        new AlertDialog.Builder((Context)this).setTitle(R.string.error).setMessage((CharSequence)errorMsg).setPositiveButton(R.string.ok, (dialog, which) -> {
            dialog.dismiss();
            this.startActivity(new Intent((Context)this, GetReadyActivity.class));
            this.finish();
        }).show();
    }

    private void onDeviceClaimedByOtherUser() {
        String dialogMsg = this.getString(R.string.dialog_title_owned_by_another_user, new Object[]{this.getString(R.string.device_name), this.sparkCloud.getLoggedInUsername()});
        new AlertDialog.Builder((Context)this).setTitle((CharSequence)this.getString(R.string.change_owner_question)).setMessage((CharSequence)dialogMsg).setPositiveButton((CharSequence)this.getString(R.string.change_owner), (dialog, which) -> {
            dialog.dismiss();
            log.i("Changing owner to " + this.sparkCloud.getLoggedInUsername());
            this.resetWorker();
            this.discoverProcessWorker.needToClaimDevice = true;
            this.discoverProcessWorker.gotOwnershipInfo = true;
            this.discoverProcessWorker.isDetectedDeviceClaimed = false;
            this.showProgressDialog();
            this.startConnectWorker();
        }).setNegativeButton(R.string.cancel, (dialog, which) -> {
            dialog.dismiss();
            this.startActivity(new Intent((Context)this, GetReadyActivity.class));
            this.finish();
        }).show();
    }

    static class DeviceAlreadyClaimed
    extends SetupStepException {
        DeviceAlreadyClaimed(String msg) {
            super(msg);
        }
    }
}

