/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.model;

import io.particle.android.sdk.devicesetup.commands.ScanApCommand;
import io.particle.android.sdk.devicesetup.commands.data.WifiSecurity;
import io.particle.android.sdk.devicesetup.model.WifiNetwork;
import io.particle.android.sdk.utils.SSID;

public class ScanAPCommandResult
implements WifiNetwork {
    public final ScanApCommand.Scan scan;
    public final SSID ssid;

    public ScanAPCommandResult(ScanApCommand.Scan scan) {
        this.scan = scan;
        this.ssid = SSID.from(scan.ssid);
    }

    @Override
    public SSID getSsid() {
        return this.ssid;
    }

    @Override
    public boolean isSecured() {
        return this.scan.wifiSecurityType.intValue() != WifiSecurity.OPEN.asInt();
    }

    public String toString() {
        return "ScanAPCommandResult{scan=" + this.scan + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScanAPCommandResult that = (ScanAPCommandResult)o;
        return this.getSsid() != null ? this.getSsid().equals(that.getSsid()) : that.getSsid() == null;
    }

    public int hashCode() {
        return this.getSsid() != null ? this.getSsid().hashCode() : 0;
    }
}

