/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.loaders;

import android.content.Context;
import android.content.IntentFilter;
import android.net.wifi.ScanResult;
import io.particle.android.sdk.devicesetup.R;
import io.particle.android.sdk.devicesetup.SimpleReceiver;
import io.particle.android.sdk.devicesetup.model.ScanResultNetwork;
import io.particle.android.sdk.utils.BetterAsyncTaskLoader;
import io.particle.android.sdk.utils.Funcy;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.TLog;
import io.particle.android.sdk.utils.WifiFacade;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class WifiScanResultLoader
extends BetterAsyncTaskLoader<Set<ScanResultNetwork>> {
    private static final TLog log = TLog.get(WifiScanResultLoader.class);
    private final WifiFacade wifiFacade;
    private final SimpleReceiver receiver;
    private volatile Set<ScanResultNetwork> mostRecentResult;
    private volatile int loadCount = 0;
    private final Funcy.Predicate<ScanResult> ssidStartsWithProductName = input -> {
        if (!Py.truthy((Object)input.SSID)) {
            return false;
        }
        String softApPrefix = (this.getContext().getString(R.string.network_name_prefix) + "-").toLowerCase(Locale.ROOT);
        return input.SSID.toLowerCase(Locale.ROOT).startsWith(softApPrefix);
    };

    public WifiScanResultLoader(Context context, WifiFacade wifiFacade) {
        super(context);
        Context appCtx = context.getApplicationContext();
        this.receiver = SimpleReceiver.newReceiver(appCtx, new IntentFilter("android.net.wifi.SCAN_RESULTS"), (ctx, intent) -> {
            log.d("Received WifiManager.SCAN_RESULTS_AVAILABLE_ACTION broadcast");
            this.forceLoad();
        });
        this.wifiFacade = wifiFacade;
    }

    @Override
    public boolean hasContent() {
        return this.mostRecentResult != null;
    }

    @Override
    public Set<ScanResultNetwork> getLoadedContent() {
        return this.mostRecentResult;
    }

    @Override
    protected void onStartLoading() {
        super.onStartLoading();
        this.receiver.register();
        this.forceLoad();
    }

    protected void onStopLoading() {
        this.receiver.unregister();
        this.cancelLoad();
    }

    public Set<ScanResultNetwork> loadInBackground() {
        List<ScanResult> scanResults = this.wifiFacade.getScanResults();
        log.d("Latest (unfiltered) scan results: " + scanResults);
        if (this.loadCount % 3 == 0) {
            this.wifiFacade.startScan();
        }
        ++this.loadCount;
        this.mostRecentResult = Py.set((Collection)Funcy.transformList(scanResults, this.ssidStartsWithProductName, ScanResultNetwork::new));
        if (this.mostRecentResult.isEmpty()) {
            log.i("No SSID scan results returned after filtering by product name.  Do you need to change the 'network_name_prefix' resource?");
        }
        return this.mostRecentResult;
    }
}

