/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.commands;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;

class CommandClientUtils {
    private static final String[][] JAVA_CTRL_CHARS_ESCAPE = new String[][]{{"\b", "\\b"}, {"\n", "\\n"}, {"\t", "\\t"}, {"\f", "\\f"}, {"\r", "\\r"}};
    private static final CharSequenceTranslator ESCAPE_JAVA = new LookupTranslator((CharSequence[][])new String[][]{{"\"", "\\\""}, {"\\", "\\\\"}}).with(new LookupTranslator((CharSequence[][])CommandClientUtils.JAVA_CTRL_CHARS_ESCAPE())).with(JavaUnicodeEscaper.access$100(32, 127));

    CommandClientUtils() {
    }

    public static String escapeJava(String input) {
        return CommandClientUtils.ESCAPE_JAVA.translate(input);
    }

    private static String[][] JAVA_CTRL_CHARS_ESCAPE() {
        return (String[][])JAVA_CTRL_CHARS_ESCAPE.clone();
    }

    static class LookupTranslator
    extends CharSequenceTranslator {
        private HashMap<String, String> lookupMap = new HashMap();
        private HashSet<Character> prefixSet = new HashSet();
        private int shortest;
        private int longest;

        private LookupTranslator(CharSequence[] ... lookup) {
            int _shortest = Integer.MAX_VALUE;
            int _longest = 0;
            if (lookup != null) {
                for (CharSequence[] seq : lookup) {
                    this.lookupMap.put(seq[0].toString(), seq[1].toString());
                    this.prefixSet.add(Character.valueOf(seq[0].charAt(0)));
                    int sz = seq[0].length();
                    if (sz < _shortest) {
                        _shortest = sz;
                    }
                    if (sz <= _longest) continue;
                    _longest = sz;
                }
            }
            this.shortest = _shortest;
            this.longest = _longest;
        }

        @Override
        int translate(CharSequence input, int index, Writer out) throws IOException {
            if (this.prefixSet.contains(Character.valueOf(input.charAt(index)))) {
                int max = this.longest;
                if (index + this.longest > input.length()) {
                    max = input.length() - index;
                }
                for (int i = max; i >= this.shortest; --i) {
                    CharSequence subSeq = input.subSequence(index, index + i);
                    String result = this.lookupMap.get(subSeq.toString());
                    if (result == null) continue;
                    out.write(result);
                    return i;
                }
            }
            return 0;
        }
    }

    private static class JavaUnicodeEscaper
    extends UnicodeEscaper {
        private static JavaUnicodeEscaper above(int codepoint) {
            return JavaUnicodeEscaper.outsideOf(0, codepoint);
        }

        private static JavaUnicodeEscaper below(int codepoint) {
            return JavaUnicodeEscaper.outsideOf(codepoint, Integer.MAX_VALUE);
        }

        private static JavaUnicodeEscaper between(int codepointLow, int codepointHigh) {
            return new JavaUnicodeEscaper(codepointLow, codepointHigh, true);
        }

        private static JavaUnicodeEscaper outsideOf(int codepointLow, int codepointHigh) {
            return new JavaUnicodeEscaper(codepointLow, codepointHigh, false);
        }

        private JavaUnicodeEscaper(int below, int above, boolean between) {
            super(below, above, between);
        }

        @Override
        protected String toUtf16Escape(int codepoint) {
            char[] surrogatePair = Character.toChars(codepoint);
            return "\\u" + JavaUnicodeEscaper.hex(surrogatePair[0]) + "\\u" + JavaUnicodeEscaper.hex(surrogatePair[1]);
        }

        static /* synthetic */ JavaUnicodeEscaper access$100(int x0, int x1) {
            return JavaUnicodeEscaper.outsideOf(x0, x1);
        }
    }

    static class UnicodeEscaper
    extends CodePointTranslator {
        private int below;
        private int above;
        private boolean between;

        private UnicodeEscaper() {
            this(0, Integer.MAX_VALUE, true);
        }

        UnicodeEscaper(int below, int above, boolean between) {
            this.below = below;
            this.above = above;
            this.between = between;
        }

        private static UnicodeEscaper below(int codepoint) {
            return UnicodeEscaper.outsideOf(codepoint, Integer.MAX_VALUE);
        }

        private static UnicodeEscaper above(int codepoint) {
            return UnicodeEscaper.outsideOf(0, codepoint);
        }

        private static UnicodeEscaper outsideOf(int codepointLow, int codepointHigh) {
            return new UnicodeEscaper(codepointLow, codepointHigh, false);
        }

        private static UnicodeEscaper between(int codepointLow, int codepointHigh) {
            return new UnicodeEscaper(codepointLow, codepointHigh, true);
        }

        @Override
        boolean translate(int codepoint, Writer out) throws IOException {
            if (this.between ? codepoint < this.below || codepoint > this.above : codepoint >= this.below && codepoint <= this.above) {
                return false;
            }
            if (codepoint > 65535) {
                out.write(this.toUtf16Escape(codepoint));
            } else {
                out.write("\\u");
                out.write(HEX_DIGITS[codepoint >> 12 & 0xF]);
                out.write(HEX_DIGITS[codepoint >> 8 & 0xF]);
                out.write(HEX_DIGITS[codepoint >> 4 & 0xF]);
                out.write(HEX_DIGITS[codepoint & 0xF]);
            }
            return true;
        }

        protected String toUtf16Escape(int codepoint) {
            return "\\u" + UnicodeEscaper.hex(codepoint);
        }
    }

    static abstract class CodePointTranslator
    extends CharSequenceTranslator {
        CodePointTranslator() {
        }

        @Override
        int translate(CharSequence input, int index, Writer out) throws IOException {
            int codepoint = Character.codePointAt(input, index);
            boolean consumed = this.translate(codepoint, out);
            return consumed ? 1 : 0;
        }

        abstract boolean translate(int var1, Writer var2) throws IOException;
    }

    private static class AggregateTranslator
    extends CharSequenceTranslator {
        private CharSequenceTranslator[] translators;

        AggregateTranslator(CharSequenceTranslator ... translators) {
            this.translators = (CharSequenceTranslator[])translators.clone();
        }

        @Override
        int translate(CharSequence input, int index, Writer out) throws IOException {
            for (CharSequenceTranslator translator : this.translators) {
                int consumed = translator.translate(input, index, out);
                if (consumed == 0) continue;
                return consumed;
            }
            return 0;
        }
    }

    private static abstract class CharSequenceTranslator {
        static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

        private CharSequenceTranslator() {
        }

        abstract int translate(CharSequence var1, int var2, Writer var3) throws IOException;

        private String translate(CharSequence input) {
            if (input == null) {
                return null;
            }
            try {
                StringWriter writer = new StringWriter(input.length() * 2);
                this.translate(input, writer);
                return writer.toString();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }

        private void translate(CharSequence input, Writer out) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException("The Writer must not be null");
            }
            if (input == null) {
                return;
            }
            int pos = 0;
            int len = input.length();
            while (pos < len) {
                int consumed = this.translate(input, pos, out);
                if (consumed == 0) {
                    char c2;
                    char c1 = input.charAt(pos);
                    out.write(c1);
                    if (!Character.isHighSurrogate(c1) || ++pos >= len || !Character.isLowSurrogate(c2 = input.charAt(pos))) continue;
                    out.write(c2);
                    ++pos;
                    continue;
                }
                for (int pt = 0; pt < consumed; ++pt) {
                    pos += Character.charCount(Character.codePointAt(input, pos));
                }
            }
        }

        CharSequenceTranslator with(CharSequenceTranslator ... translators) {
            CharSequenceTranslator[] newArray = new CharSequenceTranslator[translators.length + 1];
            newArray[0] = this;
            System.arraycopy(translators, 0, newArray, 1, translators.length);
            return new AggregateTranslator(newArray);
        }

        static String hex(int codepoint) {
            return Integer.toHexString(codepoint).toUpperCase(Locale.ENGLISH);
        }
    }
}

