/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup;

import android.app.Activity;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.LocalBroadcastManager;
import io.particle.android.sdk.cloud.ParticleCloudSDK;
import io.particle.android.sdk.devicesetup.SetupCompleteIntentBuilder;
import io.particle.android.sdk.devicesetup.SetupResult;
import io.particle.android.sdk.devicesetup.ui.GetReadyActivity;
import io.particle.android.sdk.di.ApplicationComponent;
import io.particle.android.sdk.di.ApplicationModule;
import io.particle.android.sdk.di.DaggerApplicationComponent;
import io.particle.android.sdk.ui.BaseActivity;
import io.particle.android.sdk.utils.Preconditions;

public class ParticleDeviceSetupLibrary {
    private ApplicationComponent applicationComponent;
    private static ParticleDeviceSetupLibrary instance;
    private SetupCompleteIntentBuilder setupCompleteIntentBuilder;

    @Deprecated
    public static void startDeviceSetup(Context ctx) {
        Preconditions.checkNotNull((Object)ParticleDeviceSetupLibrary.instance.setupCompleteIntentBuilder, (Object)"SetupCompleteIntentBuilder instance is null");
        ctx.startActivity(new Intent(ctx, GetReadyActivity.class));
    }

    public static void startDeviceSetup(Context ctx, SetupCompleteIntentBuilder setupCompleteIntentBuilder) {
        ParticleDeviceSetupLibrary.instance.setupCompleteIntentBuilder = setupCompleteIntentBuilder;
        ParticleDeviceSetupLibrary.startDeviceSetup(ctx);
    }

    public static void startDeviceSetup(Context ctx, Class<? extends Activity> mainActivity) {
        ParticleDeviceSetupLibrary.startDeviceSetup(ctx, (Context ctx1, SetupResult result) -> new Intent(ctx1, mainActivity));
    }

    @Deprecated
    public static void init(Context ctx, Class<? extends Activity> mainActivity) {
        ParticleDeviceSetupLibrary.init(ctx);
        ParticleDeviceSetupLibrary.instance.setupCompleteIntentBuilder = (ctx1, result) -> new Intent(ctx1, mainActivity);
    }

    public static void init(Context ctx) {
        if (instance == null) {
            ParticleCloudSDK.init((Context)ctx);
            instance = new ParticleDeviceSetupLibrary();
            instance.setComponent(DaggerApplicationComponent.builder().applicationModule(new ApplicationModule((Application)ctx.getApplicationContext())).build());
        }
    }

    public static void initWithSetupOnly(Context ctx) {
        BaseActivity.setupOnly = true;
        ParticleDeviceSetupLibrary.init(ctx);
    }

    public static ParticleDeviceSetupLibrary getInstance() {
        Preconditions.checkNotNull((Object)instance, (Object)"Library instance is null: did you call ParticleDeviceSetupLibrary.init()?");
        return instance;
    }

    @Deprecated
    public SetupCompleteIntentBuilder getSetupCompleteIntentBuilder() {
        return this.setupCompleteIntentBuilder;
    }

    private ParticleDeviceSetupLibrary() {
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public ApplicationComponent getApplicationComponent() {
        return this.applicationComponent;
    }

    @VisibleForTesting
    public void setComponent(ApplicationComponent applicationComponent) {
        this.applicationComponent = applicationComponent;
    }

    public static abstract class DeviceSetupCompleteReceiver
    extends BroadcastReceiver {
        public abstract void onSetupSuccess(@NonNull String var1);

        public abstract void onSetupFailure();

        public void register(Context ctx) {
            LocalBroadcastManager.getInstance((Context)ctx).registerReceiver((BroadcastReceiver)this, this.buildIntentFilter());
        }

        public void unregister(Context ctx) {
            LocalBroadcastManager.getInstance((Context)ctx).unregisterReceiver((BroadcastReceiver)this);
        }

        public void onReceive(Context context, Intent intent) {
            boolean success = intent.getBooleanExtra("EXTRA_DEVICE_SETUP_WAS_SUCCESSFUL", false);
            String deviceId = intent.getStringExtra("EXTRA_CONFIGURED_DEVICE_ID");
            if (success && deviceId != null) {
                this.onSetupSuccess(deviceId);
            } else {
                this.onSetupFailure();
            }
        }

        public IntentFilter buildIntentFilter() {
            return new IntentFilter("ACTION_DEVICE_SETUP_COMPLETE");
        }
    }

    public static interface DeviceSetupCompleteContract {
        public static final String ACTION_DEVICE_SETUP_COMPLETE = "ACTION_DEVICE_SETUP_COMPLETE";
        public static final String EXTRA_DEVICE_SETUP_WAS_SUCCESSFUL = "EXTRA_DEVICE_SETUP_WAS_SUCCESSFUL";
        public static final String EXTRA_CONFIGURED_DEVICE_ID = "EXTRA_CONFIGURED_DEVICE_ID";
    }
}

