/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.MainThread;
import io.particle.android.sdk.devicesetup.SimpleReceiver;
import io.particle.android.sdk.utils.EZ;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.SSID;
import io.particle.android.sdk.utils.SoftAPConfigRemover;
import io.particle.android.sdk.utils.TLog;
import io.particle.android.sdk.utils.WifiFacade;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

@MainThread
public class ApConnector {
    private static final TLog log = TLog.get(ApConnector.class);
    public static final long CONNECT_TO_DEVICE_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(20L);
    private static final IntentFilter WIFI_STATE_CHANGE_FILTER = new IntentFilter("android.net.wifi.STATE_CHANGE");
    private final DecoratedClient client;
    private final WifiFacade wifiFacade;
    private final SimpleReceiver wifiLogger;
    private final Context appContext;
    private final SoftAPConfigRemover softAPConfigRemover;
    private final Handler mainThreadHandler;
    private final List<Runnable> setupRunnables = Py.list();
    private SimpleReceiver wifiStateChangeListener;
    private Runnable onTimeoutRunnable;

    public static WifiConfiguration buildUnsecuredConfig(SSID ssid) {
        WifiConfiguration config = new WifiConfiguration();
        config.SSID = ssid.inQuotes();
        config.hiddenSSID = false;
        config.allowedKeyManagement.set(0);
        config.priority = 999999;
        return config;
    }

    public ApConnector(Context ctx, SoftAPConfigRemover softAPConfigRemover, WifiFacade wifiFacade) {
        this.appContext = ctx.getApplicationContext();
        this.client = new DecoratedClient();
        this.wifiFacade = wifiFacade;
        this.softAPConfigRemover = softAPConfigRemover;
        this.mainThreadHandler = new Handler(Looper.getMainLooper());
        this.wifiLogger = SimpleReceiver.newReceiver(this.appContext, new IntentFilter("android.net.wifi.STATE_CHANGE"), (context, intent) -> {
            log.d("Received android.net.wifi.STATE_CHANGE");
            log.d("EXTRA_NETWORK_INFO: " + intent.getParcelableExtra("networkInfo"));
            WifiInfo wifiInfo = (WifiInfo)intent.getParcelableExtra("wifiInfo");
            log.d("WIFI_INFO: " + wifiInfo);
        });
    }

    public SSID connectToAP(WifiConfiguration config, Client client) {
        this.wifiLogger.register();
        this.client.setDecoratedClient(client);
        this.clearState();
        SSID configSSID = SSID.from(config);
        WifiInfo currentConnectionInfo = this.wifiFacade.getConnectionInfo();
        if (ApConnector.isAlreadyConnectedToTargetNetwork(currentConnectionInfo, configSSID)) {
            client.onApConnectionSuccessful(config);
            return null;
        }
        this.scheduleTimeoutCheck(CONNECT_TO_DEVICE_TIMEOUT_MILLIS, config);
        this.wifiStateChangeListener = SimpleReceiver.newRegisteredReceiver(this.appContext, WIFI_STATE_CHANGE_FILTER, (ctx, intent) -> this.onWifiChangeBroadcastReceived(intent, config));
        boolean useMoreComplexConnectionProcess = Build.VERSION.SDK_INT < 18;
        AtomicInteger networkID = new AtomicInteger(-1);
        int alreadyConfiguredId = this.wifiFacade.getIdForConfiguredNetwork(configSSID);
        if (alreadyConfiguredId != -1 && !useMoreComplexConnectionProcess) {
            this.setupRunnables.add(() -> {
                if (this.wifiFacade.removeNetwork(alreadyConfiguredId)) {
                    log.d("Removed already-configured " + configSSID + " network successfully");
                } else {
                    log.e("Somehow failed to remove the already-configured network!?");
                }
            });
        }
        if (alreadyConfiguredId == -1 || !useMoreComplexConnectionProcess) {
            this.setupRunnables.add(() -> {
                WifiConfiguration configuration;
                log.d("Adding network " + configSSID);
                networkID.set(this.wifiFacade.addNetwork(config));
                if (networkID.get() == -1 && (configuration = this.wifiFacade.getWifiConfiguration(configSSID)) != null) {
                    networkID.set(configuration.networkId);
                }
                if (networkID.get() == -1) {
                    log.e("Adding network " + configSSID + " failed.");
                    client.onApConnectionFailed(config);
                } else {
                    log.i("Added network with ID " + networkID + " successfully");
                }
            });
        }
        if (useMoreComplexConnectionProcess) {
            this.setupRunnables.add(() -> {
                log.d("Disconnecting from networks; reconnecting momentarily.");
                this.wifiFacade.disconnect();
            });
        }
        this.setupRunnables.add(() -> {
            log.i("Enabling network " + configSSID + " with network ID " + networkID.get());
            this.wifiFacade.enableNetwork(networkID.get(), !useMoreComplexConnectionProcess);
        });
        if (useMoreComplexConnectionProcess) {
            this.setupRunnables.add(() -> {
                log.d("Disconnecting from networks; reconnecting momentarily.");
                this.wifiFacade.reconnect();
            });
        }
        SSID currentlyConnectedSSID = this.wifiFacade.getCurrentlyConnectedSSID();
        this.softAPConfigRemover.onWifiNetworkDisabled(currentlyConnectedSSID);
        long timeout = 0L;
        for (Runnable runnable : this.setupRunnables) {
            EZ.runOnMainThreadDelayed((long)timeout, (Runnable)runnable);
            timeout += 1500L;
        }
        return SSID.from(currentConnectionInfo);
    }

    public void stop() {
        this.client.setDecoratedClient(null);
        this.clearState();
        this.wifiLogger.unregister();
    }

    private static boolean isAlreadyConnectedToTargetNetwork(WifiInfo currentConnectionInfo, SSID targetNetworkSsid) {
        return ApConnector.isCurrentlyConnectedToAWifiNetwork(currentConnectionInfo) && targetNetworkSsid.equals(SSID.from(currentConnectionInfo));
    }

    private static boolean isCurrentlyConnectedToAWifiNetwork(WifiInfo currentConnectionInfo) {
        return currentConnectionInfo != null && Py.truthy((Object)currentConnectionInfo.getSSID()) && currentConnectionInfo.getNetworkId() != -1 && !"0x".equals(currentConnectionInfo.getSSID());
    }

    private void scheduleTimeoutCheck(long timeoutInMillis, WifiConfiguration config) {
        this.onTimeoutRunnable = () -> this.client.onApConnectionFailed(config);
        this.mainThreadHandler.postDelayed(this.onTimeoutRunnable, timeoutInMillis);
    }

    private void clearState() {
        if (this.onTimeoutRunnable != null) {
            this.mainThreadHandler.removeCallbacks(this.onTimeoutRunnable);
            this.onTimeoutRunnable = null;
        }
        if (this.wifiStateChangeListener != null) {
            this.appContext.unregisterReceiver((BroadcastReceiver)this.wifiStateChangeListener);
            this.wifiStateChangeListener = null;
        }
        for (Runnable runnable : this.setupRunnables) {
            this.mainThreadHandler.removeCallbacks(runnable);
        }
        this.setupRunnables.clear();
    }

    private void onWifiChangeBroadcastReceived(Intent intent, WifiConfiguration config) {
        WifiInfo wifiInfo = (WifiInfo)intent.getParcelableExtra("wifiInfo");
        if (wifiInfo == null || wifiInfo.getSSID() == null) {
            return;
        }
        SSID newlyConnectedSSID = SSID.from(wifiInfo);
        log.i("Connected to: " + newlyConnectedSSID);
        if (newlyConnectedSSID.equals(SSID.from(config))) {
            this.client.onApConnectionSuccessful(config);
        }
    }

    private class DecoratedClient
    implements Client {
        Client decoratedClient;

        private DecoratedClient() {
        }

        @Override
        public void onApConnectionSuccessful(WifiConfiguration config) {
            ApConnector.this.clearState();
            if (this.decoratedClient != null) {
                this.decoratedClient.onApConnectionSuccessful(config);
            }
        }

        @Override
        public void onApConnectionFailed(WifiConfiguration config) {
            ApConnector.this.clearState();
            if (this.decoratedClient != null) {
                this.decoratedClient.onApConnectionFailed(config);
            }
        }

        void setDecoratedClient(Client decoratedClient) {
            this.decoratedClient = decoratedClient;
        }
    }

    public static interface Client {
        public void onApConnectionSuccessful(WifiConfiguration var1);

        public void onApConnectionFailed(WifiConfiguration var1);
    }
}

