/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.accountsetup;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.text.TextUtils;
import android.view.View;
import android.widget.EditText;
import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.OnClick;
import butterknife.OnEditorAction;
import butterknife.OnTextChanged;
import com.squareup.phrase.Phrase;
import io.particle.android.sdk.accountsetup.CreateAccountActivity;
import io.particle.android.sdk.accountsetup.PasswordResetActivity;
import io.particle.android.sdk.cloud.ParticleCloud;
import io.particle.android.sdk.cloud.ParticleCloudException;
import io.particle.android.sdk.cloud.SDKGlobals;
import io.particle.android.sdk.devicesetup.ParticleDeviceSetupLibrary;
import io.particle.android.sdk.devicesetup.R;
import io.particle.android.sdk.di.ApModule;
import io.particle.android.sdk.ui.BaseActivity;
import io.particle.android.sdk.ui.NextActivitySelector;
import io.particle.android.sdk.utils.Async;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.SEGAnalytics;
import io.particle.android.sdk.utils.TLog;
import io.particle.android.sdk.utils.ui.ParticleUi;
import io.particle.android.sdk.utils.ui.Ui;
import javax.inject.Inject;

public class LoginActivity
extends BaseActivity {
    private static final TLog log = TLog.get(LoginActivity.class);
    private Async.AsyncApiWorker<ParticleCloud, Void> loginTask = null;
    @BindView(value=2131492936)
    protected EditText emailView;
    @BindView(value=2131492982)
    protected EditText passwordView;
    @Inject
    protected ParticleCloud sparkCloud;

    @OnEditorAction(value={2131492982})
    protected boolean onPasswordEditorAction(int id2) {
        if (id2 == R.id.action_log_in || id2 == 0) {
            this.attemptLogin();
            return true;
        }
        return false;
    }

    @OnTextChanged(value={2131492936, 2131492982}, callback=OnTextChanged.Callback.AFTER_TEXT_CHANGED)
    protected void afterInput() {
        this.emailView.setError(null);
        this.passwordView.setError(null);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.particle_activity_login);
        ParticleDeviceSetupLibrary.getInstance().getApplicationComponent().activityComponentBuilder().apModule(new ApModule()).build().inject(this);
        ButterKnife.bind((Activity)this);
        ParticleUi.enableBrandLogoInverseVisibilityAgainstSoftKeyboard((FragmentActivity)this);
        SEGAnalytics.screen("Auth: Login Screen");
        Ui.setText((FragmentActivity)this, R.id.log_in_header_text, Phrase.from((Context)this, (int)R.string.log_in_header_text).put("brand_name", (CharSequence)this.getString(R.string.brand_name)).format());
        Ui.setTextFromHtml((FragmentActivity)this, R.id.user_has_no_account, R.string.msg_no_account).setOnClickListener(v -> {
            this.startActivity(new Intent(v.getContext(), CreateAccountActivity.class));
            this.finish();
        });
        Ui.setTextFromHtml((FragmentActivity)this, R.id.forgot_password, R.string.msg_forgot_password);
    }

    public void onPasswordResetClicked(View v) {
        Intent intent = PasswordResetActivity.buildIntent((Context)this, this.emailView.getText().toString());
        this.startActivity(intent);
    }

    @OnClick(value={2131492887})
    public void attemptLogin() {
        if (this.loginTask != null) {
            log.wtf("Login being attempted again even though the button isn't enabled?!");
            return;
        }
        this.emailView.setError(null);
        this.passwordView.setError(null);
        String email = this.emailView.getText().toString();
        String password = this.passwordView.getText().toString();
        boolean cancel = false;
        EditText focusView = null;
        if (!TextUtils.isEmpty((CharSequence)password) && !this.isPasswordValid(password)) {
            this.passwordView.setError((CharSequence)this.getString(R.string.error_invalid_password));
            focusView = this.passwordView;
            cancel = true;
        }
        if (TextUtils.isEmpty((CharSequence)email)) {
            this.emailView.setError((CharSequence)this.getString(R.string.error_field_required));
            focusView = this.emailView;
            cancel = true;
        } else if (!this.isEmailValid(email)) {
            this.emailView.setError((CharSequence)this.getString(R.string.error_invalid_email));
            focusView = this.emailView;
            cancel = true;
        }
        if (cancel) {
            focusView.requestFocus();
        } else {
            this.login(email, password);
        }
    }

    private void login(final String email, final String password) {
        ParticleUi.showParticleButtonProgress((FragmentActivity)this, R.id.action_log_in, true);
        this.loginTask = Async.executeAsync((ParticleCloud)this.sparkCloud, (Async.ApiWork)new Async.ApiWork<ParticleCloud, Void>(){

            public Void callApi(@NonNull ParticleCloud sparkCloud) throws ParticleCloudException {
                sparkCloud.logIn(email, password);
                return null;
            }

            public void onTaskFinished() {
                LoginActivity.this.loginTask = null;
            }

            public void onSuccess(@NonNull Void result) {
                SEGAnalytics.identify(email);
                SEGAnalytics.track("Auth: Login success");
                log.d("Logged in...");
                if (LoginActivity.this.isFinishing()) {
                    return;
                }
                LoginActivity.this.startActivity(NextActivitySelector.getNextActivityIntent((Context)LoginActivity.this, LoginActivity.this.sparkCloud, SDKGlobals.getSensitiveDataStorage(), null));
                LoginActivity.this.finish();
            }

            public void onFailure(@NonNull ParticleCloudException error) {
                log.d("onFailed(): " + error.getMessage());
                SEGAnalytics.track("Auth: Login failure");
                ParticleUi.showParticleButtonProgress((FragmentActivity)LoginActivity.this, R.id.action_log_in, false);
                LoginActivity.this.passwordView.setError((CharSequence)error.getBestMessage());
                LoginActivity.this.passwordView.requestFocus();
            }
        });
    }

    private boolean isEmailValid(String email) {
        return Py.truthy((Object)email) && email.contains("@");
    }

    private boolean isPasswordValid(String password) {
        return password.length() > 0;
    }
}

