/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.utils.ui;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.app.Dialog;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.ContextCompat;
import android.text.Html;
import android.view.View;
import android.widget.TextView;

public class Ui {
    public static <T extends View> T findView(FragmentActivity activity, int id2) {
        return (T)activity.findViewById(id2);
    }

    public static <T extends View> T findView(View enclosingView, int id2) {
        return (T)enclosingView.findViewById(id2);
    }

    public static <T extends View> T findView(Fragment frag, int id2) {
        return (T)frag.getActivity().findViewById(id2);
    }

    public static <T extends View> T findView(Dialog dialog, int id2) {
        return (T)dialog.findViewById(id2);
    }

    public static <T extends Fragment> T findFrag(FragmentActivity activity, int id2) {
        return (T)activity.getSupportFragmentManager().findFragmentById(id2);
    }

    public static <T extends Fragment> T findFrag(FragmentActivity activity, String tag) {
        return (T)activity.getSupportFragmentManager().findFragmentByTag(tag);
    }

    public static TextView setText(FragmentActivity activity, int textViewId, CharSequence text) {
        TextView textView = (TextView)Ui.findView(activity, textViewId);
        textView.setText(text);
        return textView;
    }

    public static TextView setText(View view, int textViewId, CharSequence text) {
        TextView textView = (TextView)Ui.findView(view, textViewId);
        textView.setText(text);
        return textView;
    }

    public static TextView setText(Fragment frag, int textViewId, CharSequence text) {
        TextView textView = (TextView)Ui.findView(frag, textViewId);
        textView.setText(text);
        return textView;
    }

    public static String getText(FragmentActivity activity, int textViewId, boolean trim) {
        TextView textView = (TextView)Ui.findView(activity, textViewId);
        String text = textView.getText().toString();
        return trim ? text.trim() : text;
    }

    public static String getText(Fragment frag, int textViewId, boolean trim) {
        TextView textView = (TextView)Ui.findView(frag, textViewId);
        String text = textView.getText().toString();
        return trim ? text.trim() : text;
    }

    public static TextView setTextFromHtml(FragmentActivity activity, int textViewId, int htmlStringId) {
        return Ui.setTextFromHtml(activity, textViewId, activity.getString(htmlStringId));
    }

    public static TextView setTextFromHtml(FragmentActivity activity, int textViewId, String htmlString) {
        TextView tv = (TextView)Ui.findView(activity, textViewId);
        tv.setText((CharSequence)Html.fromHtml((String)htmlString), TextView.BufferType.SPANNABLE);
        return tv;
    }

    public static void fadeViewVisibility(FragmentActivity activity, int viewId, boolean show) {
        int shortAnimTime = activity.getResources().getInteger(0x10E0000);
        Object progressView = Ui.findView(activity, viewId);
        progressView.setVisibility(0);
        progressView.animate().setDuration((long)shortAnimTime).alpha(show ? 1.0f : 0.0f).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter((View)progressView, show){
            final /* synthetic */ View val$progressView;
            final /* synthetic */ boolean val$show;
            {
                this.val$progressView = view;
                this.val$show = bl;
            }

            public void onAnimationEnd(Animator animation) {
                this.val$progressView.setVisibility(this.val$show ? 0 : 8);
            }
        });
    }

    public static Drawable getTintedDrawable(Context ctx, @DrawableRes int drawableResId, @ColorRes int colorResId) {
        Resources res = ctx.getResources();
        Drawable drawable2 = ContextCompat.getDrawable((Context)ctx, (int)drawableResId);
        int color2 = res.getColor(colorResId);
        drawable2.setColorFilter(color2, PorterDuff.Mode.SRC_IN);
        return drawable2;
    }
}

