/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import io.particle.android.sdk.utils.Funcy;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.SSID;
import io.particle.android.sdk.utils.SoftAPConfigRemover$$Lambda$1;
import io.particle.android.sdk.utils.SoftAPConfigRemover$$Lambda$2;
import io.particle.android.sdk.utils.TLog;
import io.particle.android.sdk.utils.WifiFacade;
import java.util.Set;

public class SoftAPConfigRemover {
    private static final TLog log = TLog.get(SoftAPConfigRemover.class);
    private static final String PREFS_SOFT_AP_NETWORK_REMOVER = "PREFS_SOFT_AP_NETWORK_REMOVER";
    private static final String KEY_SOFT_AP_SSIDS = "KEY_SOFT_AP_SSIDS";
    private static final String KEY_DISABLED_WIFI_SSIDS = "KEY_DISABLED_WIFI_SSIDS";
    private final Context ctx;
    private final SharedPreferences prefs;
    private final WifiFacade wifiFacade;

    public SoftAPConfigRemover(Context context) {
        this.ctx = context.getApplicationContext();
        this.wifiFacade = WifiFacade.get(this.ctx);
        this.prefs = this.ctx.getSharedPreferences(PREFS_SOFT_AP_NETWORK_REMOVER, 0);
    }

    public void onSoftApConfigured(SSID newSsid) {
        Py.PySet ssids = Py.set(this.loadSSIDsWithKey(KEY_SOFT_AP_SSIDS));
        ssids.add(newSsid);
        this.saveWithKey(KEY_SOFT_AP_SSIDS, (Set<SSID>)ssids);
    }

    public void removeAllSoftApConfigs() {
        for (SSID ssid : this.loadSSIDsWithKey(KEY_SOFT_AP_SSIDS)) {
            this.wifiFacade.removeNetwork(ssid);
        }
        this.saveWithKey(KEY_SOFT_AP_SSIDS, (Set<SSID>)Py.set((Object[])new SSID[0]));
    }

    public void onWifiNetworkDisabled(SSID ssid) {
        log.v("onWifiNetworkDisabled() " + ssid);
        Py.PySet ssids = Py.set(this.loadSSIDsWithKey(KEY_DISABLED_WIFI_SSIDS));
        ssids.add(ssid);
        this.saveWithKey(KEY_DISABLED_WIFI_SSIDS, (Set<SSID>)ssids);
    }

    public void reenableWifiNetworks() {
        log.v("reenableWifiNetworks()");
        WifiFacade wifiFacade = WifiFacade.get(this.ctx);
        for (SSID ssid : this.loadSSIDsWithKey(KEY_DISABLED_WIFI_SSIDS)) {
            wifiFacade.reenableNetwork(ssid);
        }
        this.saveWithKey(KEY_DISABLED_WIFI_SSIDS, (Set<SSID>)Py.set((Object[])new SSID[0]));
    }

    private Set<SSID> loadSSIDsWithKey(String key) {
        return Funcy.transformSet((Set)this.prefs.getStringSet(key, (Set)Py.set((Object[])new String[0])), (Funcy.Func)SoftAPConfigRemover$$Lambda$1.lambdaFactory$());
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private void saveWithKey(String key, Set<SSID> ssids) {
        Set asStrings = Funcy.transformSet(ssids, (Funcy.Func)SoftAPConfigRemover$$Lambda$2.lambdaFactory$());
        this.prefs.edit().putStringSet(key, asStrings).apply();
    }
}

