/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.ui;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.util.Log;
import io.particle.android.sdk.devicesetup.R;
import io.particle.android.sdk.devicesetup.ui.PermissionsFragment$$Lambda$1;
import io.particle.android.sdk.devicesetup.ui.PermissionsFragment$$Lambda$2;
import io.particle.android.sdk.devicesetup.ui.PermissionsFragment$$Lambda$3;
import io.particle.android.sdk.utils.WorkerFragment;
import io.particle.android.sdk.utils.ui.Ui;
import java.util.Arrays;

public class PermissionsFragment
extends Fragment
implements ActivityCompat.OnRequestPermissionsResultCallback {
    public static final String TAG = WorkerFragment.buildFragmentTag(PermissionsFragment.class);
    private static final int REQUEST_CODE = 128;

    public static <T extends FragmentActivity> PermissionsFragment ensureAttached(T callbacksActivity) {
        PermissionsFragment frag = PermissionsFragment.get(callbacksActivity);
        if (frag == null) {
            frag = new PermissionsFragment();
            WorkerFragment.addFragment(callbacksActivity, frag, TAG);
        }
        return frag;
    }

    public static <T extends FragmentActivity> PermissionsFragment get(T callbacksActivity) {
        return (PermissionsFragment)((Object)Ui.findFrag(callbacksActivity, TAG));
    }

    public static boolean hasPermission(@NonNull Context ctx, @NonNull String permission2) {
        int result = ContextCompat.checkSelfPermission((Context)ctx, (String)permission2);
        return result == 0;
    }

    public void ensurePermission(@NonNull String permission2) {
        AlertDialog.Builder dialogBuilder = new AlertDialog.Builder((Context)this.getActivity()).setCancelable(false);
        if (ActivityCompat.checkSelfPermission((Context)this.getActivity(), (String)permission2) != 0 || ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.getActivity(), (String)permission2)) {
            dialogBuilder.setTitle(R.string.location_permission_dialog_title).setMessage(R.string.location_permission_dialog_text).setPositiveButton(R.string.got_it, PermissionsFragment$$Lambda$1.lambdaFactory$(this, permission2));
        } else {
            dialogBuilder.setTitle(R.string.location_permission_denied_dialog_title).setMessage(R.string.location_permission_denied_dialog_text).setPositiveButton(R.string.settings, PermissionsFragment$$Lambda$2.lambdaFactory$(this)).setNegativeButton(R.string.exit_setup, PermissionsFragment$$Lambda$3.lambdaFactory$(this, permission2));
        }
        dialogBuilder.show();
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        Log.i((String)TAG, (String)String.format("onRequestPermissionsResult(%d, %s, %s)", requestCode, Arrays.toString(permissions), Arrays.toString(grantResults)));
        if (requestCode != 128) {
            Log.i((String)TAG, (String)("Unrecognized request code: " + requestCode));
        }
        String permission2 = permissions[0];
        if (PermissionsFragment.hasPermission((Context)this.getActivity(), permission2)) {
            Client client = (Client)this.getActivity();
            client.onUserAllowedPermission(permission2);
        } else {
            this.ensurePermission(permission2);
        }
    }

    private void requestPermission(String permission2) {
        ActivityCompat.requestPermissions((Activity)this.getActivity(), (String[])new String[]{permission2}, (int)128);
    }

    /* synthetic */ void lambda$ensurePermission$2(@NonNull String permission2, DialogInterface dialog, int which) {
        Client client = (Client)this.getActivity();
        client.onUserDeniedPermission(permission2);
    }

    /* synthetic */ void lambda$ensurePermission$1(DialogInterface dialog, int which) {
        dialog.dismiss();
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        String pkgName = this.getActivity().getApplicationInfo().packageName;
        intent.setData(Uri.parse((String)("package:" + pkgName)));
        this.startActivity(intent);
    }

    /* synthetic */ void lambda$ensurePermission$0(@NonNull String permission2, DialogInterface dialog, int which) {
        dialog.dismiss();
        this.requestPermission(permission2);
    }

    public static interface Client {
        public void onUserAllowedPermission(String var1);

        public void onUserDeniedPermission(String var1);
    }
}

