/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.ui;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import io.particle.android.sdk.devicesetup.R;
import io.particle.android.sdk.devicesetup.commands.CommandClient;
import io.particle.android.sdk.devicesetup.commands.ScanApCommand;
import io.particle.android.sdk.devicesetup.commands.data.WifiSecurity;
import io.particle.android.sdk.devicesetup.loaders.ScanApCommandLoader;
import io.particle.android.sdk.devicesetup.model.ScanAPCommandResult;
import io.particle.android.sdk.devicesetup.ui.ConnectingActivity;
import io.particle.android.sdk.devicesetup.ui.ManualNetworkEntryActivity$$Lambda$1;
import io.particle.android.sdk.devicesetup.ui.PasswordEntryActivity;
import io.particle.android.sdk.ui.BaseActivity;
import io.particle.android.sdk.utils.SEGAnalytics;
import io.particle.android.sdk.utils.SSID;
import io.particle.android.sdk.utils.WifiFacade;
import io.particle.android.sdk.utils.ui.ParticleUi;
import io.particle.android.sdk.utils.ui.Ui;
import java.util.Set;

public class ManualNetworkEntryActivity
extends BaseActivity
implements LoaderManager.LoaderCallbacks<Set<ScanAPCommandResult>> {
    private static final String EXTRA_SOFT_AP = "EXTRA_SOFT_AP";
    private WifiFacade wifiFacade;
    private SSID softApSSID;
    private final CompoundButton.OnCheckedChangeListener secureCheckListener = ManualNetworkEntryActivity$$Lambda$1.lambdaFactory$();

    public static Intent buildIntent(Context ctx, SSID softApSSID) {
        return new Intent(ctx, ManualNetworkEntryActivity.class).putExtra(EXTRA_SOFT_AP, (Parcelable)softApSSID);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        SEGAnalytics.screen("Device Setup: Manual network entry screen");
        this.softApSSID = (SSID)this.getIntent().getParcelableExtra(EXTRA_SOFT_AP);
        this.wifiFacade = WifiFacade.get((Context)this);
        this.setContentView(R.layout.activity_manual_network_entry);
        CheckBox secureCheckbox = (CheckBox)Ui.findView((FragmentActivity)this, R.id.network_requires_password);
        secureCheckbox.setOnCheckedChangeListener(this.secureCheckListener);
        ParticleUi.enableBrandLogoInverseVisibilityAgainstSoftKeyboard((FragmentActivity)this);
    }

    public void onConnectClicked(View view) {
        String ssid = Ui.getText((FragmentActivity)this, R.id.network_name, true);
        ScanApCommand.Scan scan = new ScanApCommand.Scan(ssid, WifiSecurity.WPA2_AES_PSK.asInt(), 0);
        CheckBox requiresPassword = (CheckBox)Ui.findView((FragmentActivity)this, R.id.network_requires_password);
        if (requiresPassword.isChecked()) {
            this.startActivity(PasswordEntryActivity.buildIntent((Context)this, this.softApSSID, scan));
        } else {
            this.startActivity(ConnectingActivity.buildIntent((Context)this, this.softApSSID, scan));
        }
    }

    public void onCancelClicked(View view) {
        this.finish();
    }

    public Loader<Set<ScanAPCommandResult>> onCreateLoader(int id2, Bundle args) {
        return new ScanApCommandLoader((Context)this, CommandClient.newClientUsingDefaultsForDevices((Context)this, this.softApSSID));
    }

    public void onLoadFinished(Loader<Set<ScanAPCommandResult>> loader, Set<ScanAPCommandResult> data) {
    }

    public void onLoaderReset(Loader<Set<ScanAPCommandResult>> loader) {
    }

    static /* synthetic */ void lambda$new$0(CompoundButton buttonView, boolean isChecked) {
        if (isChecked) {
            SEGAnalytics.track("Device Setup: Selected secured network");
        } else {
            SEGAnalytics.track("Device Setup: Selected open network");
        }
    }
}

