/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.setupsteps;

import android.content.Context;
import io.particle.android.sdk.devicesetup.SetupProcessException;
import io.particle.android.sdk.devicesetup.setupsteps.SetupStep;
import io.particle.android.sdk.devicesetup.setupsteps.SetupStepException;
import io.particle.android.sdk.devicesetup.setupsteps.StepConfig;
import io.particle.android.sdk.devicesetup.ui.DeviceSetupState;
import io.particle.android.sdk.utils.EZ;
import io.particle.android.sdk.utils.Preconditions;
import io.particle.android.sdk.utils.SSID;
import io.particle.android.sdk.utils.WifiFacade;

public class WaitForDisconnectionFromDeviceStep
extends SetupStep {
    private final SSID softApName;
    private final WifiFacade wifiFacade;
    private boolean wasDisconnected = false;

    public WaitForDisconnectionFromDeviceStep(StepConfig stepConfig, SSID softApSSID, Context ctx) {
        super(stepConfig);
        Preconditions.checkNotNull((Object)softApSSID, (Object)"softApSSID cannot be null.");
        this.softApName = softApSSID;
        this.wifiFacade = WifiFacade.get(ctx);
    }

    @Override
    public boolean isStepFulfilled() {
        return this.wasDisconnected;
    }

    @Override
    protected void onRunStep() throws SetupStepException, SetupProcessException {
        for (int i = 0; i <= 5; ++i) {
            if (!this.isConnectedToSoftAp()) {
                EZ.threadSleep((long)1000L);
                this.wasDisconnected = true;
                if (EZ.isUsingOlderWifiStack()) {
                    this.reenablePreviousWifi();
                }
                return;
            }
            EZ.threadSleep((long)200L);
        }
        throw new SetupStepException("Not disconnected from soft AP");
    }

    private void reenablePreviousWifi() {
        SSID prevSSID = DeviceSetupState.previouslyConnectedWifiNetwork;
        this.wifiFacade.reenableNetwork(prevSSID);
        this.wifiFacade.reassociate();
    }

    private boolean isConnectedToSoftAp() {
        SSID currentlyConnectedSSID = this.wifiFacade.getCurrentlyConnectedSSID();
        this.log.d("Currently connected SSID: " + currentlyConnectedSSID);
        return this.softApName.equals(currentlyConnectedSSID);
    }
}

