/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.setupsteps;

import android.net.wifi.WifiConfiguration;
import android.os.Handler;
import io.particle.android.sdk.devicesetup.ApConnector;
import io.particle.android.sdk.devicesetup.setupsteps.SetupStepApReconnector$$Lambda$1;
import io.particle.android.sdk.devicesetup.setupsteps.SetupStepApReconnector$$Lambda$2;
import io.particle.android.sdk.utils.SSID;
import io.particle.android.sdk.utils.WifiFacade;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class SetupStepApReconnector {
    private final WifiFacade wifiFacade;
    private final ApConnector apConnector;
    private final Handler mainThreadHandler;
    private final SSID softApSSID;
    private final WifiConfiguration config;

    public SetupStepApReconnector(WifiFacade wifiFacade, ApConnector apConnector, Handler mainThreadHandler, SSID softApSSID) {
        this.wifiFacade = wifiFacade;
        this.apConnector = apConnector;
        this.mainThreadHandler = mainThreadHandler;
        this.softApSSID = softApSSID;
        this.config = ApConnector.buildUnsecuredConfig(softApSSID);
    }

    void ensureConnectionToSoftAp() throws IOException {
        if (this.isConnectedToSoftAp()) {
            return;
        }
        CountDownLatch latch = new CountDownLatch(1);
        AtomicBoolean gotConnected = new AtomicBoolean(false);
        this.mainThread(SetupStepApReconnector$$Lambda$1.lambdaFactory$(this, gotConnected, latch));
        this.awaitCountdown(latch, ApConnector.CONNECT_TO_DEVICE_TIMEOUT_MILLIS + 50L);
        if (!gotConnected.get()) {
            throw new IOException("ApConnector did not finish in time; could not reconnect to soft AP");
        }
    }

    private boolean isConnectedToSoftAp() {
        return this.softApSSID.equals(this.wifiFacade.getCurrentlyConnectedSSID());
    }

    private CountDownLatch mainThread(Runnable runnable) {
        CountDownLatch latch = new CountDownLatch(1);
        this.mainThreadHandler.post(SetupStepApReconnector$$Lambda$2.lambdaFactory$(runnable, latch));
        return latch;
    }

    private boolean awaitCountdown(CountDownLatch latch, long awaitMs) {
        try {
            return latch.await(awaitMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
    }

    static /* synthetic */ void lambda$mainThread$1(Runnable runnable, CountDownLatch latch) {
        runnable.run();
        latch.countDown();
    }

    /* synthetic */ void lambda$ensureConnectionToSoftAp$0(final AtomicBoolean gotConnected, final CountDownLatch latch) {
        this.apConnector.connectToAP(this.config, new ApConnector.Client(){

            @Override
            public void onApConnectionSuccessful(WifiConfiguration config) {
                gotConnected.set(true);
                latch.countDown();
            }

            @Override
            public void onApConnectionFailed(WifiConfiguration config) {
                latch.countDown();
            }
        });
    }
}

