/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.loaders;

import android.content.Context;
import io.particle.android.sdk.devicesetup.commands.CommandClient;
import io.particle.android.sdk.devicesetup.commands.ScanApCommand;
import io.particle.android.sdk.devicesetup.loaders.ScanApCommandLoader$$Lambda$1;
import io.particle.android.sdk.devicesetup.model.ScanAPCommandResult;
import io.particle.android.sdk.utils.BetterAsyncTaskLoader;
import io.particle.android.sdk.utils.Funcy;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.TLog;
import java.io.IOException;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ScanApCommandLoader
extends BetterAsyncTaskLoader<Set<ScanAPCommandResult>> {
    private static final TLog log = TLog.get(ScanApCommandLoader.class);
    private final CommandClient commandClient;
    private final Set<ScanAPCommandResult> accumulatedResults = Py.set((Object[])new ScanAPCommandResult[0]);

    public ScanApCommandLoader(Context context, CommandClient client) {
        super(context);
        this.commandClient = client;
    }

    @Override
    public boolean hasContent() {
        return !this.accumulatedResults.isEmpty();
    }

    @Override
    public Set<ScanAPCommandResult> getLoadedContent() {
        return this.accumulatedResults;
    }

    @Override
    protected void onStartLoading() {
        super.onStartLoading();
        this.forceLoad();
    }

    protected void onStopLoading() {
        this.cancelLoad();
    }

    public Set<ScanAPCommandResult> loadInBackground() {
        try {
            ScanApCommand.Response response = this.commandClient.sendCommand(new ScanApCommand(), ScanApCommand.Response.class);
            this.accumulatedResults.addAll(Funcy.transformList(response.getScans(), (Funcy.Func)ScanApCommandLoader$$Lambda$1.lambdaFactory$()));
            log.d("Latest accumulated scan results: " + this.accumulatedResults);
            return Py.set(this.accumulatedResults);
        }
        catch (IOException e) {
            log.e("Error running scan-ap command: ", (Throwable)e);
            return null;
        }
    }
}

