/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.commands.data;

import android.util.SparseArray;
import io.particle.android.sdk.utils.Preconditions;

public enum WifiSecurity {
    OPEN(0),
    WEP_PSK(1),
    WEP_SHARED(32769),
    WPA_TKIP_PSK(0x200002),
    WPA_AES_PSK(0x200004),
    WPA_MIXED_PSK(0x200006),
    WPA2_AES_PSK(0x400004),
    WPA2_TKIP_PSK(0x400002),
    WPA2_MIXED_PSK(0x400006);

    static final SparseArray<WifiSecurity> fromIntMap;
    private final int intValue;
    private static final int ENTERPRISE_ENABLED_MASK = 0x2000000;

    private WifiSecurity(int intValue) {
        this.intValue = intValue;
    }

    public static boolean isEnterpriseNetwork(int value) {
        return (0x2000000 & value) != 0;
    }

    public static WifiSecurity fromInteger(Integer value) {
        Preconditions.checkNotNull((Object)value);
        fromIntMap.indexOfKey(value.intValue());
        Preconditions.checkArgument((fromIntMap.indexOfKey(value.intValue()) >= 0 ? 1 : 0) != 0, (String)("Value not found in map: " + value));
        return (WifiSecurity)((Object)fromIntMap.get(value.intValue()));
    }

    public int asInt() {
        return this.intValue;
    }

    static {
        fromIntMap = new SparseArray();
        fromIntMap.put(OPEN.asInt(), (Object)OPEN);
        fromIntMap.put(WEP_PSK.asInt(), (Object)WEP_PSK);
        fromIntMap.put(WEP_SHARED.asInt(), (Object)WEP_SHARED);
        fromIntMap.put(WPA_TKIP_PSK.asInt(), (Object)WPA_TKIP_PSK);
        fromIntMap.put(WPA_MIXED_PSK.asInt(), (Object)WPA_MIXED_PSK);
        fromIntMap.put(WPA_AES_PSK.asInt(), (Object)WPA_AES_PSK);
        fromIntMap.put(WPA2_AES_PSK.asInt(), (Object)WPA2_AES_PSK);
        fromIntMap.put(WPA2_TKIP_PSK.asInt(), (Object)WPA2_TKIP_PSK);
        fromIntMap.put(WPA2_MIXED_PSK.asInt(), (Object)WPA2_MIXED_PSK);
    }
}

