/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.commands;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.Network;
import android.os.Build;
import io.particle.android.sdk.utils.SSID;
import io.particle.android.sdk.utils.TLog;
import io.particle.android.sdk.utils.WifiFacade;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.SocketFactory;

public class NetworkBindingSocketFactory
extends SocketFactory {
    private static final TLog log = TLog.get(NetworkBindingSocketFactory.class);
    private final WifiFacade wifiFacade;
    private final SSID softAPSSID;
    private final int timeoutMillis;

    public NetworkBindingSocketFactory(Context ctx, SSID softAPSSID, int timeoutMillis) {
        this.wifiFacade = WifiFacade.get(ctx);
        this.softAPSSID = softAPSSID;
        this.timeoutMillis = timeoutMillis;
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.buildSocket();
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        Socket socket = this.buildSocket();
        socket.connect(new InetSocketAddress(host, port), this.timeoutMillis);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        throw new UnsupportedOperationException("Specifying a localHost or localPort arg is not supported.");
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        Socket socket = this.buildSocket();
        socket.connect(new InetSocketAddress(host, port), this.timeoutMillis);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        throw new UnsupportedOperationException("Specifying a localHost or localPort arg is not supported.");
    }

    private Socket buildSocket() throws IOException {
        Socket socket = new Socket();
        socket.setSoTimeout(this.timeoutMillis);
        if (Build.VERSION.SDK_INT >= 21) {
            this.bindSocketToSoftAp(socket);
        }
        return socket;
    }

    @TargetApi(value=21)
    private void bindSocketToSoftAp(Socket socket) throws IOException {
        Network softAp = this.wifiFacade.getNetworkForSSID(this.softAPSSID);
        if (softAp == null) {
            throw new SocketBindingException("Could not find Network for SSID " + this.softAPSSID);
        }
        softAp.bindSocket(socket);
    }

    private static class SocketBindingException
    extends IOException {
        SocketBindingException(String msg) {
            super(msg);
        }
    }
}

