/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.commands;

import com.google.gson.annotations.SerializedName;
import io.particle.android.sdk.devicesetup.commands.Command;
import io.particle.android.sdk.devicesetup.commands.data.WifiSecurity;
import io.particle.android.sdk.utils.Py;

public class ConfigureApCommand
extends Command {
    public final Integer idx;
    public final String ssid;
    @SerializedName(value="pwd")
    public final String encryptedPasswordHex;
    @SerializedName(value="sec")
    public final Integer wifiSecurityType;
    @SerializedName(value="ch")
    public final Integer channel;

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public String getCommandName() {
        return "configure-ap";
    }

    private ConfigureApCommand(int idx, String ssid, String encryptedPasswordHex, WifiSecurity wifiSecurityType, int channel) {
        this.idx = idx;
        this.ssid = ssid;
        this.encryptedPasswordHex = encryptedPasswordHex;
        this.wifiSecurityType = wifiSecurityType.asInt();
        this.channel = channel;
    }

    public static class Builder {
        private Integer idx;
        private String ssid;
        private String encryptedPasswordHex;
        private WifiSecurity securityType;
        private Integer channel;

        public Builder setIdx(int idx) {
            this.idx = idx;
            return this;
        }

        public Builder setSsid(String ssid) {
            this.ssid = ssid;
            return this;
        }

        public Builder setEncryptedPasswordHex(String encryptedPasswordHex) {
            this.encryptedPasswordHex = encryptedPasswordHex;
            return this;
        }

        public Builder setSecurityType(WifiSecurity securityType) {
            this.securityType = securityType;
            return this;
        }

        public Builder setChannel(int channel) {
            this.channel = channel;
            return this;
        }

        public ConfigureApCommand build() {
            if (!Py.all((Object[])new Object[]{this.ssid, this.securityType}) || Py.truthy((Object)this.encryptedPasswordHex) && this.securityType == WifiSecurity.OPEN) {
                throw new IllegalArgumentException("One or more required arguments was not set on ConfigureApCommand");
            }
            if (this.idx == null) {
                this.idx = 0;
            }
            return new ConfigureApCommand(this.idx, this.ssid, this.encryptedPasswordHex, this.securityType, this.channel);
        }
    }

    public static class Response {
        @SerializedName(value="r")
        public final Integer responseCode;

        public Response(Integer responseCode) {
            this.responseCode = responseCode;
        }

        public boolean isOk() {
            return this.responseCode == 0;
        }

        public String toString() {
            return "Response{responseCode=" + this.responseCode + '}';
        }
    }
}

