/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;

public class SimpleReceiver
extends BroadcastReceiver {
    private final Context appContext;
    private final IntentFilter intentFilter;
    private final LambdafiableBroadcastReceiver receiver;
    private boolean registered = false;

    public static SimpleReceiver newReceiver(Context ctx, IntentFilter intentFilter, LambdafiableBroadcastReceiver receiver) {
        return new SimpleReceiver(ctx, intentFilter, receiver);
    }

    public static SimpleReceiver newRegisteredReceiver(Context ctx, IntentFilter intentFilter, LambdafiableBroadcastReceiver receiver) {
        SimpleReceiver sr = new SimpleReceiver(ctx, intentFilter, receiver);
        sr.register();
        return sr;
    }

    private SimpleReceiver(Context ctx, IntentFilter intentFilter, LambdafiableBroadcastReceiver receiver) {
        this.appContext = ctx.getApplicationContext();
        this.intentFilter = intentFilter;
        this.receiver = receiver;
    }

    public void onReceive(Context context, Intent intent) {
        this.receiver.onReceive(context, intent);
    }

    public void register() {
        if (this.registered) {
            return;
        }
        this.appContext.registerReceiver((BroadcastReceiver)this, this.intentFilter);
        this.registered = true;
    }

    public void unregister() {
        if (!this.registered) {
            return;
        }
        this.appContext.unregisterReceiver((BroadcastReceiver)this);
        this.registered = false;
    }

    public static interface LambdafiableBroadcastReceiver {
        public void onReceive(Context var1, Intent var2);
    }
}

