/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.MainThread;
import io.particle.android.sdk.devicesetup.ApConnector$$Lambda$1;
import io.particle.android.sdk.devicesetup.ApConnector$$Lambda$2;
import io.particle.android.sdk.devicesetup.ApConnector$$Lambda$3;
import io.particle.android.sdk.devicesetup.ApConnector$$Lambda$4;
import io.particle.android.sdk.devicesetup.ApConnector$$Lambda$5;
import io.particle.android.sdk.devicesetup.ApConnector$$Lambda$6;
import io.particle.android.sdk.devicesetup.ApConnector$$Lambda$7;
import io.particle.android.sdk.devicesetup.ApConnector$$Lambda$8;
import io.particle.android.sdk.devicesetup.SimpleReceiver;
import io.particle.android.sdk.utils.EZ;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.SSID;
import io.particle.android.sdk.utils.SoftAPConfigRemover;
import io.particle.android.sdk.utils.TLog;
import io.particle.android.sdk.utils.WifiFacade;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

@MainThread
public class ApConnector {
    private static final TLog log = TLog.get(ApConnector.class);
    public static final long CONNECT_TO_DEVICE_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(20L);
    private static final IntentFilter WIFI_STATE_CHANGE_FILTER = new IntentFilter("android.net.wifi.STATE_CHANGE");
    private final DecoratedClient client;
    private final WifiFacade wifiFacade;
    private final SimpleReceiver wifiLogger;
    private final Context appContext;
    private final SoftAPConfigRemover softAPConfigRemover;
    private final Handler mainThreadHandler;
    private final List<Runnable> setupRunnables = Py.list();
    private SimpleReceiver wifiStateChangeListener;
    private Runnable onTimeoutRunnable;

    public static WifiConfiguration buildUnsecuredConfig(SSID ssid) {
        WifiConfiguration config = new WifiConfiguration();
        config.SSID = ssid.inQuotes();
        config.hiddenSSID = false;
        config.allowedKeyManagement.set(0);
        config.priority = 999999;
        return config;
    }

    public ApConnector(Context ctx) {
        this.appContext = ctx.getApplicationContext();
        this.client = new DecoratedClient();
        this.wifiFacade = WifiFacade.get(this.appContext);
        this.softAPConfigRemover = new SoftAPConfigRemover(this.appContext);
        this.mainThreadHandler = new Handler(Looper.getMainLooper());
        this.wifiLogger = SimpleReceiver.newReceiver(this.appContext, new IntentFilter("android.net.wifi.STATE_CHANGE"), ApConnector$$Lambda$1.lambdaFactory$());
    }

    public SSID connectToAP(WifiConfiguration config, Client client) {
        this.wifiLogger.register();
        this.client.setDecoratedClient(client);
        this.clearState();
        SSID configSSID = SSID.from(config);
        WifiInfo currentConnectionInfo = this.wifiFacade.getConnectionInfo();
        if (ApConnector.isAlreadyConnectedToTargetNetwork(currentConnectionInfo, configSSID)) {
            client.onApConnectionSuccessful(config);
            return null;
        }
        this.scheduleTimeoutCheck(CONNECT_TO_DEVICE_TIMEOUT_MILLIS, config);
        this.wifiStateChangeListener = SimpleReceiver.newRegisteredReceiver(this.appContext, WIFI_STATE_CHANGE_FILTER, ApConnector$$Lambda$2.lambdaFactory$(this, config));
        boolean useMoreComplexConnectionProcess = Build.VERSION.SDK_INT < 18;
        AtomicInteger networkID = new AtomicInteger(-1);
        int alreadyConfiguredId = this.wifiFacade.getIdForConfiguredNetwork(configSSID);
        if (alreadyConfiguredId != -1 && !useMoreComplexConnectionProcess) {
            this.setupRunnables.add(ApConnector$$Lambda$3.lambdaFactory$(this, alreadyConfiguredId, configSSID));
        }
        if (alreadyConfiguredId == -1 || !useMoreComplexConnectionProcess) {
            this.setupRunnables.add(ApConnector$$Lambda$4.lambdaFactory$(this, configSSID, networkID, config, client));
        }
        if (useMoreComplexConnectionProcess) {
            this.setupRunnables.add(ApConnector$$Lambda$5.lambdaFactory$(this));
        }
        this.setupRunnables.add(ApConnector$$Lambda$6.lambdaFactory$(this, configSSID, networkID, useMoreComplexConnectionProcess));
        if (useMoreComplexConnectionProcess) {
            this.setupRunnables.add(ApConnector$$Lambda$7.lambdaFactory$(this));
        }
        SSID currentlyConnectedSSID = this.wifiFacade.getCurrentlyConnectedSSID();
        this.softAPConfigRemover.onWifiNetworkDisabled(currentlyConnectedSSID);
        long timeout = 0L;
        for (Runnable runnable : this.setupRunnables) {
            EZ.runOnMainThreadDelayed((long)timeout, (Runnable)runnable);
            timeout += 1500L;
        }
        return SSID.from(currentConnectionInfo);
    }

    public void stop() {
        this.client.setDecoratedClient(null);
        this.clearState();
        this.wifiLogger.unregister();
    }

    private static boolean isAlreadyConnectedToTargetNetwork(WifiInfo currentConnectionInfo, SSID targetNetworkSsid) {
        return ApConnector.isCurrentlyConnectedToAWifiNetwork(currentConnectionInfo) && targetNetworkSsid.equals(SSID.from(currentConnectionInfo));
    }

    private static boolean isCurrentlyConnectedToAWifiNetwork(WifiInfo currentConnectionInfo) {
        return currentConnectionInfo != null && Py.truthy((Object)currentConnectionInfo.getSSID()) && currentConnectionInfo.getNetworkId() != -1 && !"0x".equals(currentConnectionInfo.getSSID());
    }

    private void scheduleTimeoutCheck(long timeoutInMillis, WifiConfiguration config) {
        this.onTimeoutRunnable = ApConnector$$Lambda$8.lambdaFactory$(this, config);
        this.mainThreadHandler.postDelayed(this.onTimeoutRunnable, timeoutInMillis);
    }

    private void clearState() {
        if (this.onTimeoutRunnable != null) {
            this.mainThreadHandler.removeCallbacks(this.onTimeoutRunnable);
            this.onTimeoutRunnable = null;
        }
        if (this.wifiStateChangeListener != null) {
            this.appContext.unregisterReceiver((BroadcastReceiver)this.wifiStateChangeListener);
            this.wifiStateChangeListener = null;
        }
        for (Runnable runnable : this.setupRunnables) {
            this.mainThreadHandler.removeCallbacks(runnable);
        }
        this.setupRunnables.clear();
    }

    private void onWifiChangeBroadcastReceived(Intent intent, WifiConfiguration config) {
        WifiInfo wifiInfo = (WifiInfo)intent.getParcelableExtra("wifiInfo");
        if (wifiInfo == null || wifiInfo.getSSID() == null) {
            return;
        }
        SSID newlyConnectedSSID = SSID.from(wifiInfo);
        log.i("Connected to: " + newlyConnectedSSID);
        if (newlyConnectedSSID.equals(SSID.from(config))) {
            this.client.onApConnectionSuccessful(config);
        }
    }

    /* synthetic */ void lambda$scheduleTimeoutCheck$7(WifiConfiguration config) {
        this.client.onApConnectionFailed(config);
    }

    /* synthetic */ void lambda$connectToAP$6() {
        log.d("Disconnecting from networks; reconnecting momentarily.");
        this.wifiFacade.reconnect();
    }

    /* synthetic */ void lambda$connectToAP$5(SSID configSSID, AtomicInteger networkID, boolean useMoreComplexConnectionProcess) {
        log.i("Enabling network " + configSSID + " with network ID " + networkID.get());
        this.wifiFacade.enableNetwork(networkID.get(), !useMoreComplexConnectionProcess);
    }

    /* synthetic */ void lambda$connectToAP$4() {
        log.d("Disconnecting from networks; reconnecting momentarily.");
        this.wifiFacade.disconnect();
    }

    /* synthetic */ void lambda$connectToAP$3(SSID configSSID, AtomicInteger networkID, WifiConfiguration config, Client client) {
        WifiConfiguration configuration;
        log.d("Adding network " + configSSID);
        networkID.set(this.wifiFacade.addNetwork(config));
        if (networkID.get() == -1 && (configuration = this.wifiFacade.getWifiConfiguration(configSSID)) != null) {
            networkID.set(configuration.networkId);
        }
        if (networkID.get() == -1) {
            log.e("Adding network " + configSSID + " failed.");
            client.onApConnectionFailed(config);
        } else {
            log.i("Added network with ID " + networkID + " successfully");
        }
    }

    /* synthetic */ void lambda$connectToAP$2(int alreadyConfiguredId, SSID configSSID) {
        if (this.wifiFacade.removeNetwork(alreadyConfiguredId)) {
            log.d("Removed already-configured " + configSSID + " network successfully");
        } else {
            log.e("Somehow failed to remove the already-configured network!?");
        }
    }

    /* synthetic */ void lambda$connectToAP$1(WifiConfiguration config, Context ctx, Intent intent) {
        this.onWifiChangeBroadcastReceived(intent, config);
    }

    static /* synthetic */ void lambda$new$0(Context context, Intent intent) {
        log.d("Received android.net.wifi.STATE_CHANGE");
        log.d("EXTRA_NETWORK_INFO: " + intent.getParcelableExtra("networkInfo"));
        WifiInfo wifiInfo = (WifiInfo)intent.getParcelableExtra("wifiInfo");
        log.d("WIFI_INFO: " + wifiInfo);
    }

    private class DecoratedClient
    implements Client {
        Client decoratedClient;

        private DecoratedClient() {
        }

        @Override
        public void onApConnectionSuccessful(WifiConfiguration config) {
            ApConnector.this.clearState();
            if (this.decoratedClient != null) {
                this.decoratedClient.onApConnectionSuccessful(config);
            }
        }

        @Override
        public void onApConnectionFailed(WifiConfiguration config) {
            ApConnector.this.clearState();
            if (this.decoratedClient != null) {
                this.decoratedClient.onApConnectionFailed(config);
            }
        }

        void setDecoratedClient(Client decoratedClient) {
            this.decoratedClient = decoratedClient;
        }
    }

    public static interface Client {
        public void onApConnectionSuccessful(WifiConfiguration var1);

        public void onApConnectionFailed(WifiConfiguration var1);
    }
}

