/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.utils.ui;

import android.content.Context;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.widget.LinearLayout;

public class SoftKeyboardVisibilityDetectingLinearLayout
extends LinearLayout {
    private boolean isKeyboardShown;
    private SoftKeyboardVisibilityChangeListener listener;

    public SoftKeyboardVisibilityDetectingLinearLayout(Context context) {
        super(context);
    }

    public SoftKeyboardVisibilityDetectingLinearLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public SoftKeyboardVisibilityDetectingLinearLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public boolean dispatchKeyEventPreIme(KeyEvent event) {
        if (event.getKeyCode() == 4 && this.isKeyboardShown) {
            this.isKeyboardShown = false;
            this.listener.onSoftKeyboardHidden();
        }
        return super.dispatchKeyEventPreIme(event);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int proposedheight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int actualHeight = this.getHeight();
        if (actualHeight > proposedheight && !this.isKeyboardShown) {
            this.isKeyboardShown = true;
            this.listener.onSoftKeyboardShown();
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public void setOnSoftKeyboardVisibilityChangeListener(SoftKeyboardVisibilityChangeListener listener) {
        this.listener = listener;
    }

    public static interface SoftKeyboardVisibilityChangeListener {
        public void onSoftKeyboardShown();

        public void onSoftKeyboardHidden();
    }
}

