/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.ui;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v4.util.Pair;
import android.util.SparseArray;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import com.segment.analytics.Properties;
import com.squareup.phrase.Phrase;
import io.particle.android.sdk.cloud.ParticleCloud;
import io.particle.android.sdk.cloud.ParticleCloudException;
import io.particle.android.sdk.cloud.ParticleCloudSDK;
import io.particle.android.sdk.cloud.ParticleDevice;
import io.particle.android.sdk.cloud.SDKGlobals;
import io.particle.android.sdk.devicesetup.R;
import io.particle.android.sdk.devicesetup.SetupResult;
import io.particle.android.sdk.devicesetup.ui.DeviceSetupState;
import io.particle.android.sdk.devicesetup.ui.SuccessActivity$$Lambda$1;
import io.particle.android.sdk.devicesetup.ui.SuccessActivity$$Lambda$2;
import io.particle.android.sdk.ui.BaseActivity;
import io.particle.android.sdk.ui.NextActivitySelector;
import io.particle.android.sdk.utils.Async;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.SEGAnalytics;
import io.particle.android.sdk.utils.ui.ParticleUi;
import io.particle.android.sdk.utils.ui.Ui;
import io.particle.android.sdk.utils.ui.WebViewActivity;
import java.io.IOException;

public class SuccessActivity
extends BaseActivity {
    public static final String EXTRA_RESULT_CODE = "EXTRA_RESULT_CODE";
    public static final String EXTRA_DEVICE_ID = "EXTRA_DEVICE_ID";
    public static final int RESULT_SUCCESS = 1;
    public static final int RESULT_SUCCESS_UNKNOWN_OWNERSHIP = 2;
    public static final int RESULT_FAILURE_CLAIMING = 3;
    public static final int RESULT_FAILURE_CONFIGURE = 4;
    public static final int RESULT_FAILURE_NO_DISCONNECT = 5;
    public static final int RESULT_FAILURE_LOST_CONNECTION_TO_DEVICE = 6;
    private static final SparseArray<Pair<Integer, Integer>> resultCodesToStringIds = new SparseArray(6);
    private EditText deviceNameView;
    private TextView deviceNameLabelView;
    private ParticleCloud particleCloud;

    public static Intent buildIntent(Context ctx, int resultCode, String deviceId) {
        return new Intent(ctx, SuccessActivity.class).putExtra(EXTRA_RESULT_CODE, resultCode).putExtra(EXTRA_DEVICE_ID, deviceId);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_success);
        this.deviceNameView = (EditText)Ui.findView((FragmentActivity)this, R.id.device_name);
        this.deviceNameLabelView = (TextView)Ui.findView((FragmentActivity)this, R.id.device_name_label);
        SEGAnalytics.screen("Device Setup: Setup Result Screen");
        this.particleCloud = ParticleCloudSDK.getCloud();
        int resultCode = this.getIntent().getIntExtra(EXTRA_RESULT_CODE, -1);
        boolean isSuccess = Py.list((Object[])new Integer[]{1, 2}).contains(resultCode);
        if (!isSuccess) {
            ImageView image = (ImageView)Ui.findView((FragmentActivity)this, R.id.result_image);
            image.setImageResource(R.drawable.fail);
            this.deviceNameView.setVisibility(8);
            Properties analyticProperties = new Properties();
            switch (resultCode) {
                case 3: {
                    analyticProperties.putValue("reason", (Object)"claiming failed");
                    break;
                }
                case 4: {
                    analyticProperties.putValue("reason", (Object)"cannot configure");
                    break;
                }
                case 5: {
                    analyticProperties.putValue("reason", (Object)"cannot disconnect");
                    break;
                }
                case 6: {
                    analyticProperties.putValue("reason", (Object)"lost connection");
                }
            }
            SEGAnalytics.track("Device Setup: Failure", analyticProperties);
        } else {
            this.showDeviceName(this.particleCloud);
            SEGAnalytics.track("Device Setup: Success", 2 == resultCode ? new Properties().putValue("reason", (Object)"not claimed") : null);
        }
        Pair<? extends CharSequence, CharSequence> resultStrings = this.buildUiStringPair(resultCode);
        Ui.setText((FragmentActivity)this, R.id.result_summary, (CharSequence)resultStrings.first);
        Ui.setText((FragmentActivity)this, R.id.result_details, (CharSequence)resultStrings.second);
        Ui.findView((FragmentActivity)this, R.id.action_done).setOnClickListener(SuccessActivity$$Lambda$1.lambdaFactory$(this, isSuccess));
        Ui.setTextFromHtml((FragmentActivity)this, R.id.action_troubleshooting, R.string.troubleshooting).setOnClickListener(SuccessActivity$$Lambda$2.lambdaFactory$(this));
    }

    private void finishSetup(final Context context, final String deviceName, final boolean isSuccess) {
        ParticleUi.showParticleButtonProgress((FragmentActivity)this, R.id.action_done, true);
        Async.executeAsync((ParticleCloud)this.particleCloud, (Async.ApiWork)new Async.ApiWork<ParticleCloud, Void>(){

            public Void callApi(@NonNull ParticleCloud cloud) throws ParticleCloudException, IOException {
                ParticleDevice device = SuccessActivity.this.particleCloud.getDevice(SuccessActivity.this.getIntent().getStringExtra(SuccessActivity.EXTRA_DEVICE_ID));
                SuccessActivity.this.setDeviceName(device, deviceName);
                return null;
            }

            public void onSuccess(@NonNull Void result) {
                SuccessActivity.this.leaveActivity(context, isSuccess);
            }

            public void onFailure(@NonNull ParticleCloudException e) {
                ParticleUi.showParticleButtonProgress((FragmentActivity)SuccessActivity.this, R.id.action_done, false);
                SuccessActivity.this.deviceNameView.setError((CharSequence)SuccessActivity.this.getString(R.string.device_naming_failure));
            }
        });
    }

    private void leaveActivity(Context context, boolean isSuccess) {
        Intent intent = NextActivitySelector.getNextActivityIntent(context, this.particleCloud, SDKGlobals.getSensitiveDataStorage(), new SetupResult(isSuccess, isSuccess ? DeviceSetupState.deviceToBeSetUpId : null));
        intent.setFlags(872448000);
        this.startActivity(intent);
        Intent result = new Intent("ACTION_DEVICE_SETUP_COMPLETE").putExtra("EXTRA_DEVICE_SETUP_WAS_SUCCESSFUL", isSuccess);
        if (isSuccess) {
            result.putExtra("EXTRA_CONFIGURED_DEVICE_ID", DeviceSetupState.deviceToBeSetUpId);
        }
        LocalBroadcastManager.getInstance((Context)context).sendBroadcast(result);
        this.finish();
    }

    private void setDeviceName(ParticleDevice device, String deviceName) throws ParticleCloudException {
        if (device.getName() != null && !device.getName().equals(deviceName)) {
            device.setName(deviceName);
        }
    }

    private void showDeviceName(ParticleCloud cloud) {
        Async.executeAsync((ParticleCloud)cloud, (Async.ApiWork)new Async.ApiWork<ParticleCloud, ParticleDevice>(){

            public ParticleDevice callApi(@NonNull ParticleCloud cloud) throws ParticleCloudException, IOException {
                return SuccessActivity.this.particleCloud.getDevice(SuccessActivity.this.getIntent().getStringExtra(SuccessActivity.EXTRA_DEVICE_ID));
            }

            public void onSuccess(@NonNull ParticleDevice particleDevice) {
                SuccessActivity.this.deviceNameLabelView.setVisibility(0);
                SuccessActivity.this.deviceNameView.setVisibility(0);
                SuccessActivity.this.deviceNameView.setText((CharSequence)particleDevice.getName());
            }

            public void onFailure(@NonNull ParticleCloudException e) {
                SuccessActivity.this.deviceNameView.setVisibility(8);
                SuccessActivity.this.deviceNameLabelView.setVisibility(8);
            }
        });
    }

    private Pair<? extends CharSequence, CharSequence> buildUiStringPair(int resultCode) {
        Pair stringIds = (Pair)resultCodesToStringIds.get(resultCode);
        return Pair.create((Object)this.getString((Integer)stringIds.first), (Object)Phrase.from((Context)this, (int)((Integer)stringIds.second)).put("device_name", (CharSequence)this.getString(R.string.device_name)).format());
    }

    /* synthetic */ void lambda$onCreate$1(View v) {
        Uri uri = Uri.parse((String)v.getContext().getString(R.string.troubleshooting_uri));
        this.startActivity(WebViewActivity.buildIntent(v.getContext(), uri));
    }

    /* synthetic */ void lambda$onCreate$0(boolean isSuccess, View v) {
        this.deviceNameView.setError(null);
        if (isSuccess) {
            if (this.deviceNameView.getText().toString().isEmpty()) {
                this.deviceNameView.setError((CharSequence)this.getString(R.string.error_field_required));
            } else {
                this.finishSetup(v.getContext(), this.deviceNameView.getText().toString(), true);
            }
        } else {
            this.leaveActivity(v.getContext(), false);
        }
    }

    static {
        resultCodesToStringIds.put(1, (Object)Pair.create((Object)R.string.setup_success_summary, (Object)R.string.setup_success_details));
        resultCodesToStringIds.put(2, (Object)Pair.create((Object)R.string.setup_success_unknown_ownership_summary, (Object)R.string.setup_success_unknown_ownership_details));
        resultCodesToStringIds.put(3, (Object)Pair.create((Object)R.string.setup_failure_claiming_summary, (Object)R.string.setup_failure_claiming_details));
        resultCodesToStringIds.put(4, (Object)Pair.create((Object)R.string.setup_failure_configure_summary, (Object)R.string.setup_failure_configure_details));
        resultCodesToStringIds.put(5, (Object)Pair.create((Object)R.string.setup_failure_no_disconnect_from_device_summary, (Object)R.string.setup_failure_no_disconnect_from_device_details));
        resultCodesToStringIds.put(6, (Object)Pair.create((Object)R.string.setup_failure_configure_summary, (Object)R.string.setup_failure_lost_connection_to_device));
    }
}

