/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.ui;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.net.wifi.WifiConfiguration;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.Loader;
import android.support.v7.app.AlertDialog;
import android.view.View;
import com.squareup.phrase.Phrase;
import io.particle.android.sdk.accountsetup.LoginActivity;
import io.particle.android.sdk.cloud.ParticleCloud;
import io.particle.android.sdk.cloud.ParticleCloudSDK;
import io.particle.android.sdk.devicesetup.ApConnector;
import io.particle.android.sdk.devicesetup.R;
import io.particle.android.sdk.devicesetup.commands.CommandClient;
import io.particle.android.sdk.devicesetup.commands.DeviceIdCommand;
import io.particle.android.sdk.devicesetup.commands.PublicKeyCommand;
import io.particle.android.sdk.devicesetup.commands.SetCommand;
import io.particle.android.sdk.devicesetup.loaders.WifiScanResultLoader;
import io.particle.android.sdk.devicesetup.model.ScanResultNetwork;
import io.particle.android.sdk.devicesetup.setupsteps.SetupStepException;
import io.particle.android.sdk.devicesetup.ui.ConnectToApFragment;
import io.particle.android.sdk.devicesetup.ui.DeviceSetupState;
import io.particle.android.sdk.devicesetup.ui.DiscoverDeviceActivity$$Lambda$1;
import io.particle.android.sdk.devicesetup.ui.DiscoverDeviceActivity$$Lambda$2;
import io.particle.android.sdk.devicesetup.ui.DiscoverDeviceActivity$$Lambda$3;
import io.particle.android.sdk.devicesetup.ui.DiscoverDeviceActivity$$Lambda$4;
import io.particle.android.sdk.devicesetup.ui.DiscoverDeviceActivity$$Lambda$5;
import io.particle.android.sdk.devicesetup.ui.DiscoverDeviceActivity$$Lambda$6;
import io.particle.android.sdk.devicesetup.ui.DiscoverDeviceActivity$$Lambda$7;
import io.particle.android.sdk.devicesetup.ui.DiscoverDeviceActivity$$Lambda$8;
import io.particle.android.sdk.devicesetup.ui.GetReadyActivity;
import io.particle.android.sdk.devicesetup.ui.RequiresWifiScansActivity;
import io.particle.android.sdk.devicesetup.ui.SelectNetworkActivity;
import io.particle.android.sdk.devicesetup.ui.WifiListFragment;
import io.particle.android.sdk.utils.Crypto;
import io.particle.android.sdk.utils.EZ;
import io.particle.android.sdk.utils.ParticleDeviceSetupInternalStringUtils;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.SEGAnalytics;
import io.particle.android.sdk.utils.SSID;
import io.particle.android.sdk.utils.SoftAPConfigRemover;
import io.particle.android.sdk.utils.TLog;
import io.particle.android.sdk.utils.WifiFacade;
import io.particle.android.sdk.utils.ui.Ui;
import io.particle.android.sdk.utils.ui.WebViewActivity;
import java.io.IOException;
import java.security.PublicKey;
import java.util.Locale;
import java.util.Set;

public class DiscoverDeviceActivity
extends RequiresWifiScansActivity
implements WifiListFragment.Client<ScanResultNetwork>,
ApConnector.Client {
    private static final int MAX_NUM_DISCOVER_PROCESS_ATTEMPTS = 5;
    private static final TLog log = TLog.get(DiscoverDeviceActivity.class);
    private WifiFacade wifiFacade;
    private ParticleCloud sparkCloud;
    private DiscoverProcessWorker discoverProcessWorker;
    private SoftAPConfigRemover softAPConfigRemover;
    private WifiListFragment wifiListFragment;
    private ProgressDialog connectToApSpinnerDialog;
    private AsyncTask<Void, Void, SetupStepException> connectToApTask;
    private boolean isResumed = false;
    private int discoverProcessAttempts = 0;
    private SSID selectedSoftApSSID;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_discover_device);
        SEGAnalytics.screen("Device Setup: Device discovery screen");
        this.wifiFacade = WifiFacade.get((Context)this);
        this.softAPConfigRemover = new SoftAPConfigRemover((Context)this);
        this.softAPConfigRemover.removeAllSoftApConfigs();
        this.softAPConfigRemover.reenableWifiNetworks();
        DeviceSetupState.previouslyConnectedWifiNetwork = this.wifiFacade.getCurrentlyConnectedSSID();
        this.sparkCloud = ParticleCloudSDK.getCloud();
        this.wifiListFragment = (WifiListFragment)((Object)Ui.findFrag((FragmentActivity)this, R.id.wifi_list_fragment));
        ConnectToApFragment.ensureAttached((FragmentActivity)this);
        this.resetWorker();
        Ui.setText((FragmentActivity)this, R.id.wifi_list_header, Phrase.from((Context)this, (int)R.string.wifi_list_header_text).put("device_name", (CharSequence)this.getString(R.string.device_name)).format());
        Ui.setText((FragmentActivity)this, R.id.msg_device_not_listed, Phrase.from((Context)this, (int)R.string.msg_device_not_listed).put("device_name", (CharSequence)this.getString(R.string.device_name)).put("setup_button_identifier", (CharSequence)this.getString(R.string.mode_button_name)).put("indicator_light", (CharSequence)this.getString(R.string.indicator_light)).put("indicator_light_setup_color_name", (CharSequence)this.getString(R.string.listen_mode_led_color_name)).format());
        Ui.setTextFromHtml((FragmentActivity)this, R.id.action_troubleshooting, R.string.troubleshooting).setOnClickListener(DiscoverDeviceActivity$$Lambda$1.lambdaFactory$(this));
        if (!Py.truthy((Object)this.sparkCloud.getLoggedInUsername())) {
            Ui.findView((FragmentActivity)this, R.id.logged_in_as).setVisibility(8);
        } else {
            Ui.setText((FragmentActivity)this, R.id.logged_in_as, Phrase.from((Context)this, (int)R.string.you_are_logged_in_as).put("username", (CharSequence)this.sparkCloud.getLoggedInUsername()).format());
        }
        Ui.findView((FragmentActivity)this, R.id.action_log_out).setOnClickListener(DiscoverDeviceActivity$$Lambda$2.lambdaFactory$(this));
        Ui.findView((FragmentActivity)this, R.id.action_cancel).setOnClickListener(DiscoverDeviceActivity$$Lambda$3.lambdaFactory$(this));
    }

    @Override
    protected void onStart() {
        super.onStart();
        if (!this.wifiFacade.isWifiEnabled()) {
            this.onWifiDisabled();
        }
    }

    protected void onResume() {
        super.onResume();
        this.isResumed = true;
    }

    protected void onPause() {
        super.onPause();
        this.isResumed = false;
    }

    private void resetWorker() {
        this.discoverProcessWorker = new DiscoverProcessWorker(CommandClient.newClientUsingDefaultsForDevices((Context)this, this.selectedSoftApSSID));
    }

    private void onWifiDisabled() {
        log.d("Wi-Fi disabled; prompting user");
        new AlertDialog.Builder((Context)this).setTitle(R.string.wifi_required).setPositiveButton(R.string.enable_wifi, DiscoverDeviceActivity$$Lambda$4.lambdaFactory$(this)).setNegativeButton(R.string.exit_setup, DiscoverDeviceActivity$$Lambda$5.lambdaFactory$(this)).show();
    }

    @Override
    public void onNetworkSelected(ScanResultNetwork selectedNetwork) {
        WifiConfiguration wifiConfig = ApConnector.buildUnsecuredConfig(selectedNetwork.getSsid());
        this.selectedSoftApSSID = selectedNetwork.getSsid();
        this.resetWorker();
        this.connectToSoftAp(wifiConfig);
    }

    private void connectToSoftAp(WifiConfiguration config) {
        ++this.discoverProcessAttempts;
        this.softAPConfigRemover.onSoftApConfigured(SSID.from(config.SSID));
        ConnectToApFragment.get((FragmentActivity)this).connectToAP(config);
        this.showProgressDialog();
    }

    @Override
    public Loader<Set<ScanResultNetwork>> createLoader(int id2, Bundle args) {
        return new WifiScanResultLoader((Context)this);
    }

    @Override
    public void onLoadFinished() {
    }

    @Override
    public String getListEmptyText() {
        return Phrase.from((Context)this, (int)R.string.empty_soft_ap_list_text).put("device_name", (CharSequence)this.getString(R.string.device_name)).format().toString();
    }

    @Override
    public int getAggroLoadingTimeMillis() {
        return 5000;
    }

    @Override
    public void onApConnectionSuccessful(WifiConfiguration config) {
        this.startConnectWorker();
    }

    @Override
    public void onApConnectionFailed(WifiConfiguration config) {
        this.hideProgressDialog();
        if (!this.canStartProcessAgain()) {
            this.onMaxAttemptsReached();
        } else {
            this.connectToSoftAp(config);
        }
    }

    private void showProgressDialog() {
        this.wifiListFragment.stopAggroLoading();
        String msg = Phrase.from((Context)this, (int)R.string.connecting_to_soft_ap).put("device_name", (CharSequence)this.getString(R.string.device_name)).format().toString();
        this.connectToApSpinnerDialog = new ProgressDialog((Context)this);
        this.connectToApSpinnerDialog.setMessage((CharSequence)msg);
        this.connectToApSpinnerDialog.setCancelable(false);
        this.connectToApSpinnerDialog.setIndeterminate(true);
        this.connectToApSpinnerDialog.show();
    }

    private void hideProgressDialog() {
        this.wifiListFragment.startAggroLoading();
        if (this.connectToApSpinnerDialog != null) {
            if (!this.isFinishing()) {
                this.connectToApSpinnerDialog.dismiss();
            }
            this.connectToApSpinnerDialog = null;
        }
    }

    private void startConnectWorker() {
        if (this.connectToApTask != null) {
            log.d("Already running connect worker " + this.connectToApTask + ", refusing to start another");
            return;
        }
        this.wifiListFragment.stopAggroLoading();
        if (!this.canStartProcessAgain()) {
            this.hideProgressDialog();
            this.onMaxAttemptsReached();
            return;
        }
        ++this.discoverProcessAttempts;
        this.connectToApTask = new AsyncTask<Void, Void, SetupStepException>(){

            protected SetupStepException doInBackground(Void ... voids) {
                try {
                    log.d("Waiting a couple seconds before trying the socket connection...");
                    EZ.threadSleep((long)2000L);
                    DiscoverDeviceActivity.this.discoverProcessWorker.doTheThing();
                    return null;
                }
                catch (SetupStepException e) {
                    log.d("Setup exception thrown: ", (Throwable)e);
                    return e;
                }
            }

            protected void onPostExecute(SetupStepException error) {
                DiscoverDeviceActivity.this.connectToApTask = null;
                if (error == null) {
                    DiscoverDeviceActivity.this.hideProgressDialog();
                    DiscoverDeviceActivity.this.startActivity(SelectNetworkActivity.buildIntent((Context)DiscoverDeviceActivity.this, DiscoverDeviceActivity.this.selectedSoftApSSID));
                    DiscoverDeviceActivity.this.finish();
                } else if (error instanceof DeviceAlreadyClaimed) {
                    DiscoverDeviceActivity.this.hideProgressDialog();
                    DiscoverDeviceActivity.this.onDeviceClaimedByOtherUser();
                } else {
                    DiscoverDeviceActivity.this.startConnectWorker();
                }
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
    }

    private boolean canStartProcessAgain() {
        return this.discoverProcessAttempts < 5;
    }

    private void onMaxAttemptsReached() {
        if (!this.isResumed) {
            this.finish();
            return;
        }
        String errorMsg = Phrase.from((Context)this, (int)R.string.unable_to_connect_to_soft_ap).put("device_name", (CharSequence)this.getString(R.string.device_name)).format().toString();
        new AlertDialog.Builder((Context)this).setTitle(R.string.error).setMessage((CharSequence)errorMsg).setPositiveButton(R.string.ok, DiscoverDeviceActivity$$Lambda$6.lambdaFactory$(this)).show();
    }

    private void onDeviceClaimedByOtherUser() {
        String dialogMsg = this.getString(R.string.dialog_title_owned_by_another_user, new Object[]{this.getString(R.string.device_name), this.sparkCloud.getLoggedInUsername()});
        new AlertDialog.Builder((Context)this).setTitle((CharSequence)this.getString(R.string.change_owner_question)).setMessage((CharSequence)dialogMsg).setPositiveButton((CharSequence)this.getString(R.string.change_owner), DiscoverDeviceActivity$$Lambda$7.lambdaFactory$(this)).setNegativeButton(R.string.cancel, DiscoverDeviceActivity$$Lambda$8.lambdaFactory$(this)).show();
    }

    /* synthetic */ void lambda$onDeviceClaimedByOtherUser$7(DialogInterface dialog, int which) {
        dialog.dismiss();
        this.startActivity(new Intent((Context)this, GetReadyActivity.class));
        this.finish();
    }

    /* synthetic */ void lambda$onDeviceClaimedByOtherUser$6(DialogInterface dialog, int which) {
        dialog.dismiss();
        log.i("Changing owner to " + this.sparkCloud.getLoggedInUsername());
        this.resetWorker();
        this.discoverProcessWorker.needToClaimDevice = true;
        this.discoverProcessWorker.gotOwnershipInfo = true;
        this.discoverProcessWorker.isDetectedDeviceClaimed = false;
        DeviceSetupState.deviceNeedsToBeClaimed = true;
        this.showProgressDialog();
        this.startConnectWorker();
    }

    /* synthetic */ void lambda$onMaxAttemptsReached$5(DialogInterface dialog, int which) {
        dialog.dismiss();
        this.startActivity(new Intent((Context)this, GetReadyActivity.class));
        this.finish();
    }

    /* synthetic */ void lambda$onWifiDisabled$4(DialogInterface dialog, int which) {
        dialog.dismiss();
        this.finish();
    }

    /* synthetic */ void lambda$onWifiDisabled$3(DialogInterface dialog, int which) {
        dialog.dismiss();
        log.i("Enabling Wi-Fi at the user's request.");
        this.wifiFacade.setWifiEnabled(true);
        this.wifiListFragment.scanAsync();
    }

    /* synthetic */ void lambda$onCreate$2(View view) {
        this.finish();
    }

    /* synthetic */ void lambda$onCreate$1(View view) {
        this.sparkCloud.logOut();
        log.i("logged out, username is: " + this.sparkCloud.getLoggedInUsername());
        this.startActivity(new Intent((Context)this, LoginActivity.class));
        this.finish();
    }

    /* synthetic */ void lambda$onCreate$0(View v) {
        Uri uri = Uri.parse((String)v.getContext().getString(R.string.troubleshooting_uri));
        this.startActivity(WebViewActivity.buildIntent(v.getContext(), uri));
    }

    static class DeviceAlreadyClaimed
    extends SetupStepException {
        DeviceAlreadyClaimed(String msg) {
            super(msg);
        }
    }

    static class DiscoverProcessWorker {
        private final CommandClient client;
        private volatile String detectedDeviceID;
        private volatile boolean isDetectedDeviceClaimed;
        private volatile boolean gotOwnershipInfo;
        private volatile boolean needToClaimDevice;

        DiscoverProcessWorker(CommandClient client) {
            this.client = client;
        }

        public void doTheThing() throws SetupStepException {
            if (!Py.truthy((Object)this.detectedDeviceID)) {
                try {
                    DeviceIdCommand.Response response = this.client.sendCommand(new DeviceIdCommand(), DeviceIdCommand.Response.class);
                    DeviceSetupState.deviceToBeSetUpId = this.detectedDeviceID = response.deviceIdHex.toLowerCase(Locale.ROOT);
                    this.isDetectedDeviceClaimed = Py.truthy((Object)response.isClaimed);
                }
                catch (IOException e) {
                    throw new SetupStepException("Process died while trying to get the device ID", e);
                }
            }
            if (DeviceSetupState.publicKey == null) {
                try {
                    DeviceSetupState.publicKey = this.getPublicKey();
                }
                catch (Crypto.CryptoException e) {
                    throw new SetupStepException("Unable to get public key: ", e);
                }
                catch (IOException e) {
                    throw new SetupStepException("Error while fetching public key: ", e);
                }
            }
            if (!this.gotOwnershipInfo) {
                this.needToClaimDevice = false;
                if (this.isDetectedDeviceClaimed) {
                    boolean deviceClaimedByUser = false;
                    for (String deviceId : DeviceSetupState.claimedDeviceIds) {
                        if (!deviceId.equalsIgnoreCase(this.detectedDeviceID)) continue;
                        deviceClaimedByUser = true;
                        break;
                    }
                    this.gotOwnershipInfo = true;
                    if (this.isDetectedDeviceClaimed && !deviceClaimedByUser) {
                        throw new DeviceAlreadyClaimed("Device already claimed by another user");
                    }
                    return;
                }
            } else {
                if (this.needToClaimDevice) {
                    this.setClaimCode();
                }
                return;
            }
            this.setClaimCode();
            this.needToClaimDevice = true;
        }

        private void setClaimCode() throws SetupStepException {
            try {
                log.d("Setting claim code using code: " + DeviceSetupState.claimCode);
                String claimCodeNoBackslashes = ParticleDeviceSetupInternalStringUtils.remove(DeviceSetupState.claimCode, "\\");
                SetCommand.Response response = this.client.sendCommand(new SetCommand("cc", claimCodeNoBackslashes), SetCommand.Response.class);
                if (Py.truthy((Object)response.responseCode)) {
                    throw new SetupStepException("Received non-zero return code from set command: " + response.responseCode);
                }
                log.d("Successfully set claim code");
            }
            catch (IOException e) {
                throw new SetupStepException(e);
            }
        }

        private PublicKey getPublicKey() throws Crypto.CryptoException, IOException {
            PublicKeyCommand.Response response = this.client.sendCommand(new PublicKeyCommand(), PublicKeyCommand.Response.class);
            return Crypto.readPublicKeyFromHexEncodedDerString(response.publicKey);
        }
    }
}

