/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.ui;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import com.google.gson.Gson;
import io.particle.android.sdk.devicesetup.R;
import io.particle.android.sdk.devicesetup.commands.ScanApCommand;
import io.particle.android.sdk.devicesetup.commands.data.WifiSecurity;
import io.particle.android.sdk.devicesetup.ui.ConnectingActivity;
import io.particle.android.sdk.devicesetup.ui.PasswordEntryActivity$$Lambda$1;
import io.particle.android.sdk.devicesetup.ui.SelectNetworkActivity;
import io.particle.android.sdk.ui.BaseActivity;
import io.particle.android.sdk.utils.SEGAnalytics;
import io.particle.android.sdk.utils.SSID;
import io.particle.android.sdk.utils.TLog;
import io.particle.android.sdk.utils.ui.ParticleUi;
import io.particle.android.sdk.utils.ui.Ui;

public class PasswordEntryActivity
extends BaseActivity {
    private static final String EXTRA_NETWORK_TO_CONFIGURE = "EXTRA_NETWORK_TO_CONFIGURE";
    private static final String EXTRA_SOFT_AP_SSID = "EXTRA_SOFT_AP_SSID";
    private static final TLog log = TLog.get(PasswordEntryActivity.class);
    private static final Gson gson = new Gson();
    private CheckBox showPwdBox;
    private EditText passwordBox;
    private ScanApCommand.Scan networkToConnectTo;
    private SSID softApSSID;

    public static Intent buildIntent(Context ctx, SSID softApSSID, ScanApCommand.Scan networkToConnectTo) {
        return new Intent(ctx, PasswordEntryActivity.class).putExtra(EXTRA_SOFT_AP_SSID, (Parcelable)softApSSID).putExtra(EXTRA_NETWORK_TO_CONFIGURE, gson.toJson((Object)networkToConnectTo));
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_password_entry);
        SEGAnalytics.screen("Device Setup: Password Entry Screen");
        ParticleUi.enableBrandLogoInverseVisibilityAgainstSoftKeyboard((FragmentActivity)this);
        this.networkToConnectTo = (ScanApCommand.Scan)gson.fromJson(this.getIntent().getStringExtra(EXTRA_NETWORK_TO_CONFIGURE), ScanApCommand.Scan.class);
        this.softApSSID = (SSID)this.getIntent().getParcelableExtra(EXTRA_SOFT_AP_SSID);
        this.passwordBox = (EditText)Ui.findView((FragmentActivity)this, R.id.password);
        this.passwordBox.requestFocus();
        this.showPwdBox = (CheckBox)Ui.findView((FragmentActivity)this, R.id.show_password);
        this.initViews();
    }

    private void initViews() {
        Ui.setText((FragmentActivity)this, R.id.ssid, (CharSequence)this.networkToConnectTo.ssid);
        Ui.setText((FragmentActivity)this, R.id.security_msg, (CharSequence)this.getSecurityTypeMsg());
        this.showPwdBox.setOnCheckedChangeListener(PasswordEntryActivity$$Lambda$1.lambdaFactory$(this));
        this.togglePasswordVisibility(this.showPwdBox.isChecked());
    }

    private void togglePasswordVisibility(boolean showPassword) {
        int inputType = showPassword ? 144 : 129;
        this.passwordBox.setInputType(inputType);
    }

    private String getSecurityTypeMsg() {
        WifiSecurity securityType = WifiSecurity.fromInteger(this.networkToConnectTo.wifiSecurityType);
        switch (securityType) {
            case WEP_SHARED: 
            case WEP_PSK: {
                return this.getString(R.string.secured_with_wep);
            }
            case WPA_AES_PSK: 
            case WPA_TKIP_PSK: 
            case WPA_MIXED_PSK: {
                return this.getString(R.string.secured_with_wpa);
            }
            case WPA2_AES_PSK: 
            case WPA2_MIXED_PSK: 
            case WPA2_TKIP_PSK: {
                return this.getString(R.string.secured_with_wpa2);
            }
        }
        log.e("No security string found for " + (Object)((Object)securityType) + "!");
        return "";
    }

    public void onCancelClicked(View view) {
        this.startActivity(SelectNetworkActivity.buildIntent((Context)this, this.softApSSID));
        this.finish();
    }

    public void onConnectClicked(View view) {
        String secret = this.passwordBox.getText().toString().trim();
        this.startActivity(ConnectingActivity.buildIntent((Context)this, this.softApSSID, this.networkToConnectTo, secret));
        this.finish();
    }

    /* synthetic */ void lambda$initViews$0(CompoundButton buttonView, boolean isChecked) {
        this.togglePasswordVisibility(isChecked);
    }
}

