/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.ui;

import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ProgressBar;
import com.google.gson.Gson;
import com.squareup.phrase.Phrase;
import io.particle.android.sdk.cloud.ParticleCloud;
import io.particle.android.sdk.cloud.ParticleCloudSDK;
import io.particle.android.sdk.cloud.ParticleDevice;
import io.particle.android.sdk.devicesetup.ApConnector;
import io.particle.android.sdk.devicesetup.R;
import io.particle.android.sdk.devicesetup.SetupProcessException;
import io.particle.android.sdk.devicesetup.commands.CommandClient;
import io.particle.android.sdk.devicesetup.commands.ScanApCommand;
import io.particle.android.sdk.devicesetup.setupsteps.CheckIfDeviceClaimedStep;
import io.particle.android.sdk.devicesetup.setupsteps.ConfigureAPStep;
import io.particle.android.sdk.devicesetup.setupsteps.ConnectDeviceToNetworkStep;
import io.particle.android.sdk.devicesetup.setupsteps.EnsureSoftApNotVisible;
import io.particle.android.sdk.devicesetup.setupsteps.SetupStep;
import io.particle.android.sdk.devicesetup.setupsteps.SetupStepApReconnector;
import io.particle.android.sdk.devicesetup.setupsteps.SetupStepsRunnerTask;
import io.particle.android.sdk.devicesetup.setupsteps.StepConfig;
import io.particle.android.sdk.devicesetup.setupsteps.StepProgress;
import io.particle.android.sdk.devicesetup.setupsteps.WaitForCloudConnectivityStep;
import io.particle.android.sdk.devicesetup.setupsteps.WaitForDisconnectionFromDeviceStep;
import io.particle.android.sdk.devicesetup.ui.ConnectingActivity$$Lambda$1;
import io.particle.android.sdk.devicesetup.ui.ConnectingActivity$ConnectingProcessWorkerTask$$Lambda$1;
import io.particle.android.sdk.devicesetup.ui.ConnectingActivity$ConnectingProcessWorkerTask$$Lambda$2;
import io.particle.android.sdk.devicesetup.ui.ConnectingActivity$ConnectingProcessWorkerTask$$Lambda$3;
import io.particle.android.sdk.devicesetup.ui.DeviceSetupState;
import io.particle.android.sdk.devicesetup.ui.RequiresWifiScansActivity;
import io.particle.android.sdk.devicesetup.ui.SuccessActivity;
import io.particle.android.sdk.utils.CoreNameGenerator;
import io.particle.android.sdk.utils.EZ;
import io.particle.android.sdk.utils.Funcy;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.SEGAnalytics;
import io.particle.android.sdk.utils.SSID;
import io.particle.android.sdk.utils.SoftAPConfigRemover;
import io.particle.android.sdk.utils.TLog;
import io.particle.android.sdk.utils.WifiFacade;
import io.particle.android.sdk.utils.ui.Ui;
import java.security.PublicKey;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class ConnectingActivity
extends RequiresWifiScansActivity {
    public static final String EXTRA_NETWORK_TO_CONFIGURE = "EXTRA_NETWORK_TO_CONFIGURE";
    public static final String EXTRA_NETWORK_SECRET = "EXTRA_NETWORK_SECRET";
    public static final String EXTRA_SOFT_AP_SSID = "EXTRA_SOFT_AP_SSID";
    private static final int MAX_RETRIES_CONFIGURE_AP = 5;
    private static final int MAX_RETRIES_CONNECT_AP = 5;
    private static final int MAX_RETRIES_DISCONNECT_FROM_DEVICE = 5;
    private static final int MAX_RETRIES_CLAIM = 5;
    private static final TLog log = TLog.get(ConnectingActivity.class);
    private static final Gson gson = new Gson();
    private ConnectingProcessWorkerTask connectingProcessWorkerTask;
    private SoftAPConfigRemover softAPConfigRemover;
    private ApConnector apConnector;
    private ScanApCommand.Scan networkToConnectTo;
    private String networkSecretPlaintext;
    private PublicKey publicKey;
    private SSID deviceSoftApSsid;
    private ParticleCloud sparkCloud;
    private String deviceId;
    private boolean needToClaimDevice;
    private Drawable tintedSpinner;
    private Drawable tintedCheckmark;

    public static Intent buildIntent(Context ctx, SSID deviceSoftApSsid, ScanApCommand.Scan networkToConnectTo) {
        return new Intent(ctx, ConnectingActivity.class).putExtra(EXTRA_NETWORK_TO_CONFIGURE, gson.toJson((Object)networkToConnectTo)).putExtra(EXTRA_SOFT_AP_SSID, (Parcelable)deviceSoftApSsid);
    }

    public static Intent buildIntent(Context ctx, SSID deviceSoftApSsid, ScanApCommand.Scan networkToConnectTo, String secret) {
        return ConnectingActivity.buildIntent(ctx, deviceSoftApSsid, networkToConnectTo).putExtra(EXTRA_NETWORK_SECRET, secret);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_connecting);
        SEGAnalytics.screen("Device Setup: Connecting progress screen");
        this.sparkCloud = ParticleCloudSDK.getCloud();
        this.publicKey = DeviceSetupState.publicKey;
        this.deviceId = DeviceSetupState.deviceToBeSetUpId;
        this.needToClaimDevice = DeviceSetupState.deviceNeedsToBeClaimed;
        this.deviceSoftApSsid = (SSID)this.getIntent().getParcelableExtra(EXTRA_SOFT_AP_SSID);
        String asJson = this.getIntent().getStringExtra(EXTRA_NETWORK_TO_CONFIGURE);
        this.networkToConnectTo = (ScanApCommand.Scan)gson.fromJson(asJson, ScanApCommand.Scan.class);
        this.networkSecretPlaintext = this.getIntent().getStringExtra(EXTRA_NETWORK_SECRET);
        log.d("Connecting to " + this.networkToConnectTo + ", with networkSecretPlaintext of size: " + (this.networkSecretPlaintext == null ? 0 : this.networkSecretPlaintext.length()));
        this.softAPConfigRemover = new SoftAPConfigRemover((Context)this);
        this.apConnector = new ApConnector((Context)this);
        Ui.setText((FragmentActivity)this, R.id.network_name, (CharSequence)this.networkToConnectTo.ssid);
        Button cancelButton = (Button)Ui.findView((FragmentActivity)this, R.id.action_cancel);
        cancelButton.setOnClickListener(ConnectingActivity$$Lambda$1.lambdaFactory$(this));
        Ui.setText((FragmentActivity)this, R.id.connecting_text, Phrase.from((Context)this, (int)R.string.connecting_text).put("device_name", (CharSequence)this.getString(R.string.device_name)).format());
        Ui.setText((FragmentActivity)this, R.id.network_name, (CharSequence)this.networkToConnectTo.ssid);
        this.tintedSpinner = Ui.getTintedDrawable((Context)this, R.drawable.progress_spinner, R.color.element_text_color);
        this.tintedCheckmark = Ui.getTintedDrawable((Context)this, R.drawable.checkmark, R.color.element_text_color);
        this.connectingProcessWorkerTask = new ConnectingProcessWorkerTask(this.buildSteps(), 15);
        this.connectingProcessWorkerTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    protected void onStop() {
        super.onStop();
        if (this.connectingProcessWorkerTask != null && !this.connectingProcessWorkerTask.isCancelled()) {
            this.connectingProcessWorkerTask.cancel(true);
            this.connectingProcessWorkerTask = null;
        }
        this.apConnector.stop();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.softAPConfigRemover.removeAllSoftApConfigs();
        this.softAPConfigRemover.reenableWifiNetworks();
    }

    private List<SetupStep> buildSteps() {
        CommandClient commandClient = CommandClient.newClientUsingDefaultsForDevices((Context)this, this.deviceSoftApSsid);
        SetupStepApReconnector reconnector = new SetupStepApReconnector(WifiFacade.get((Context)this), this.apConnector, new Handler(), this.deviceSoftApSsid);
        ConfigureAPStep configureAPStep = new ConfigureAPStep(StepConfig.newBuilder().setMaxAttempts(5).setResultCode(4).setStepId(R.id.configure_device_wifi_credentials).build(), commandClient, reconnector, this.networkToConnectTo, this.networkSecretPlaintext, this.publicKey);
        ConnectDeviceToNetworkStep connectDeviceToNetworkStep = new ConnectDeviceToNetworkStep(StepConfig.newBuilder().setMaxAttempts(5).setResultCode(4).setStepId(R.id.connect_to_wifi_network).build(), commandClient, reconnector);
        WaitForDisconnectionFromDeviceStep waitForDisconnectionFromDeviceStep = new WaitForDisconnectionFromDeviceStep(StepConfig.newBuilder().setMaxAttempts(5).setResultCode(5).setStepId(R.id.reconnect_to_wifi_network).build(), this.deviceSoftApSsid, (Context)this);
        EnsureSoftApNotVisible ensureSoftApNotVisible = new EnsureSoftApNotVisible(StepConfig.newBuilder().setMaxAttempts(5).setResultCode(4).setStepId(R.id.wait_for_device_cloud_connection).build(), this.deviceSoftApSsid, (Context)this);
        WaitForCloudConnectivityStep waitForLocalCloudConnectivityStep = new WaitForCloudConnectivityStep(StepConfig.newBuilder().setMaxAttempts(5).setResultCode(5).setStepId(R.id.check_for_internet_connectivity).build(), this.sparkCloud, this.getApplicationContext());
        CheckIfDeviceClaimedStep checkIfDeviceClaimedStep = new CheckIfDeviceClaimedStep(StepConfig.newBuilder().setMaxAttempts(5).setResultCode(3).setStepId(R.id.verify_product_ownership).build(), this.sparkCloud, this.deviceId, this.needToClaimDevice);
        return Py.list((Object[])new SetupStep[]{configureAPStep, connectDeviceToNetworkStep, waitForDisconnectionFromDeviceStep, ensureSoftApNotVisible, waitForLocalCloudConnectivityStep, checkIfDeviceClaimedStep});
    }

    /* synthetic */ void lambda$onCreate$0(View v) {
        this.connectingProcessWorkerTask.cancel(false);
        this.finish();
    }

    private class ConnectingProcessWorkerTask
    extends SetupStepsRunnerTask {
        ConnectingProcessWorkerTask(List<SetupStep> steps, int maxOverallAttempts) {
            super(steps, maxOverallAttempts);
        }

        protected void onProgressUpdate(StepProgress ... values) {
            for (StepProgress progress : values) {
                View v = ConnectingActivity.this.findViewById(progress.stepId);
                if (v == null) continue;
                this.updateProgress(progress, v);
            }
        }

        protected void onPostExecute(SetupProcessException error) {
            int resultCode;
            if (error != null) {
                resultCode = error.failedStep.getStepConfig().resultCode;
            } else {
                log.d("HUZZAH, VICTORY!");
                resultCode = 1;
                EZ.runAsync((Runnable)ConnectingActivity$ConnectingProcessWorkerTask$$Lambda$1.lambdaFactory$(this));
            }
            ConnectingActivity.this.startActivity(SuccessActivity.buildIntent((Context)ConnectingActivity.this, resultCode, ConnectingActivity.this.deviceId));
            ConnectingActivity.this.finish();
        }

        private void updateProgress(StepProgress progress, View progressStepContainer) {
            ProgressBar progBar = (ProgressBar)Ui.findView(progressStepContainer, R.id.spinner);
            ImageView checkmark = (ImageView)Ui.findView(progressStepContainer, R.id.checkbox);
            if (checkmark.getVisibility() == 0) {
                return;
            }
            progressStepContainer.setVisibility(0);
            if (progress.status == 1) {
                checkmark.setVisibility(8);
                progBar.setProgressDrawable(ConnectingActivity.this.tintedSpinner);
                progBar.setVisibility(0);
            } else {
                progBar.setVisibility(8);
                checkmark.setImageDrawable(ConnectingActivity.this.tintedCheckmark);
                checkmark.setVisibility(0);
            }
        }

        /* synthetic */ void lambda$onPostExecute$0() {
            try {
                Py.PySet names = Py.set((Collection)Funcy.transformList((List)ConnectingActivity.this.sparkCloud.getDevices(), (Funcy.Predicate)Funcy.notNull(), (Funcy.Func)ConnectingActivity$ConnectingProcessWorkerTask$$Lambda$2.lambdaFactory$(), (Funcy.Predicate)ConnectingActivity$ConnectingProcessWorkerTask$$Lambda$3.lambdaFactory$()));
                ParticleDevice device = ConnectingActivity.this.sparkCloud.getDevice(ConnectingActivity.this.deviceId);
                if (device != null && !Py.truthy((Object)device.getName())) {
                    device.setName(CoreNameGenerator.generateUniqueName((Set<String>)names));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

