/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.setupsteps;

import android.support.annotation.AnyThread;
import android.support.annotation.WorkerThread;
import io.particle.android.sdk.devicesetup.SetupProcessException;
import io.particle.android.sdk.devicesetup.setupsteps.SetupStepException;
import io.particle.android.sdk.devicesetup.setupsteps.StepConfig;
import io.particle.android.sdk.utils.TLog;

@WorkerThread
public abstract class SetupStep {
    protected final TLog log = TLog.get(this.getClass());
    private final StepConfig stepConfig;
    private volatile int numAttempts;

    public SetupStep(StepConfig stepConfig) {
        this.stepConfig = stepConfig;
    }

    protected abstract void onRunStep() throws SetupStepException, SetupProcessException;

    public abstract boolean isStepFulfilled();

    public final void runStep() throws SetupStepException, SetupProcessException {
        if (this.isStepFulfilled()) {
            this.log.i("Step " + this.getStepName() + " already fulfilled, skipping...");
            return;
        }
        if (this.numAttempts > this.stepConfig.maxAttempts) {
            String msg = String.format("Exceeded limit of %d retries for step %s", this.stepConfig.maxAttempts, this.getStepName());
            throw new SetupProcessException(msg, this);
        }
        this.log.i("Running step " + this.getStepName());
        ++this.numAttempts;
        this.onRunStep();
    }

    @AnyThread
    public StepConfig getStepConfig() {
        return this.stepConfig;
    }

    protected void resetAttemptsCount() {
        this.numAttempts = 0;
    }

    private String getStepName() {
        return this.getClass().getSimpleName();
    }
}

