/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.accountsetup;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AlertDialog;
import android.view.View;
import android.widget.EditText;
import io.particle.android.sdk.accountsetup.PasswordResetActivity$$Lambda$1;
import io.particle.android.sdk.accountsetup.PasswordResetActivity$$Lambda$2;
import io.particle.android.sdk.accountsetup.PasswordResetActivity$$Lambda$3;
import io.particle.android.sdk.cloud.ParticleCloud;
import io.particle.android.sdk.cloud.ParticleCloudException;
import io.particle.android.sdk.cloud.ParticleCloudSDK;
import io.particle.android.sdk.devicesetup.R;
import io.particle.android.sdk.ui.BaseActivity;
import io.particle.android.sdk.utils.Async;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.SEGAnalytics;
import io.particle.android.sdk.utils.TLog;
import io.particle.android.sdk.utils.ui.ParticleUi;
import io.particle.android.sdk.utils.ui.Ui;

public class PasswordResetActivity
extends BaseActivity {
    private static final TLog log = TLog.get(PasswordResetActivity.class);
    public static final String EXTRA_EMAIL = "EXTRA_EMAIL";
    private ParticleCloud sparkCloud;
    private EditText emailView;
    private Async.AsyncApiWorker<ParticleCloud, Void> resetTask = null;

    public static Intent buildIntent(Context context, String email) {
        Intent i = new Intent(context, PasswordResetActivity.class);
        if (Py.truthy((Object)email)) {
            i.putExtra(EXTRA_EMAIL, email);
        }
        return i;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_password_reset);
        SEGAnalytics.screen("Auth: Forgot password screen");
        ParticleUi.enableBrandLogoInverseVisibilityAgainstSoftKeyboard((FragmentActivity)this);
        this.sparkCloud = ParticleCloudSDK.getCloud();
        Ui.findView((FragmentActivity)this, R.id.action_cancel).setOnClickListener(PasswordResetActivity$$Lambda$1.lambdaFactory$(this));
        this.emailView = (EditText)Ui.findView((FragmentActivity)this, R.id.email);
    }

    public void onPasswordResetClicked(View v) {
        SEGAnalytics.track("Auth: Request password reset");
        String email = this.emailView.getText().toString();
        if (this.isEmailValid(email)) {
            this.performReset();
        } else {
            new AlertDialog.Builder((Context)this).setTitle((CharSequence)this.getString(R.string.reset_password_dialog_title)).setMessage((CharSequence)this.getString(R.string.reset_paassword_dialog_please_enter_a_valid_email)).setPositiveButton(R.string.ok, PasswordResetActivity$$Lambda$2.lambdaFactory$(this)).show();
        }
    }

    private void performReset() {
        ParticleUi.showParticleButtonProgress((FragmentActivity)this, R.id.action_reset_password, true);
        this.resetTask = Async.executeAsync((ParticleCloud)this.sparkCloud, (Async.ApiWork)new Async.ApiWork<ParticleCloud, Void>(){

            public Void callApi(@NonNull ParticleCloud sparkCloud) throws ParticleCloudException {
                sparkCloud.requestPasswordReset(PasswordResetActivity.this.emailView.getText().toString());
                return null;
            }

            public void onTaskFinished() {
                PasswordResetActivity.this.resetTask = null;
                ParticleUi.showParticleButtonProgress((FragmentActivity)PasswordResetActivity.this, R.id.action_reset_password, false);
            }

            public void onSuccess(@NonNull Void result) {
                PasswordResetActivity.this.onResetAttemptFinished("Instructions for how to reset your password will be sent to the provided email address.  Please check your email and continue according to instructions.");
            }

            public void onFailure(@NonNull ParticleCloudException error) {
                log.d("onFailed(): " + error.getMessage());
                PasswordResetActivity.this.onResetAttemptFinished("Could not find a user with supplied email address, please  check the address supplied or create a new user via the signup screen");
            }
        });
    }

    private void onResetAttemptFinished(String content) {
        new AlertDialog.Builder((Context)this).setMessage((CharSequence)content).setPositiveButton(R.string.ok, PasswordResetActivity$$Lambda$3.lambdaFactory$(this)).show();
    }

    private boolean isEmailValid(String email) {
        return Py.truthy((Object)email) && email.contains("@");
    }

    /* synthetic */ void lambda$onResetAttemptFinished$2(DialogInterface dialog, int which) {
        dialog.dismiss();
        this.finish();
    }

    /* synthetic */ void lambda$onPasswordResetClicked$1(DialogInterface dialog, int which) {
        dialog.dismiss();
        this.emailView.requestFocus();
    }

    /* synthetic */ void lambda$onCreate$0(View view) {
        this.finish();
    }
}

