/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.accountsetup;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.util.Patterns;
import android.view.View;
import android.widget.Button;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.Switch;
import com.segment.analytics.Properties;
import com.squareup.phrase.Phrase;
import io.particle.android.sdk.accountsetup.CreateAccountActivity$$Lambda$1;
import io.particle.android.sdk.accountsetup.CreateAccountActivity$$Lambda$2;
import io.particle.android.sdk.accountsetup.CreateAccountActivity$$Lambda$3;
import io.particle.android.sdk.accountsetup.LoginActivity;
import io.particle.android.sdk.cloud.ParticleCloud;
import io.particle.android.sdk.cloud.ParticleCloudException;
import io.particle.android.sdk.cloud.ParticleCloudSDK;
import io.particle.android.sdk.cloud.SDKGlobals;
import io.particle.android.sdk.cloud.models.AccountInfo;
import io.particle.android.sdk.cloud.models.SignUpInfo;
import io.particle.android.sdk.devicesetup.R;
import io.particle.android.sdk.ui.BaseActivity;
import io.particle.android.sdk.ui.NextActivitySelector;
import io.particle.android.sdk.utils.Async;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.SEGAnalytics;
import io.particle.android.sdk.utils.TLog;
import io.particle.android.sdk.utils.ui.ParticleUi;
import io.particle.android.sdk.utils.ui.Toaster;
import io.particle.android.sdk.utils.ui.Ui;

public class CreateAccountActivity
extends BaseActivity {
    private static final TLog log = TLog.get(CreateAccountActivity.class);
    private Async.AsyncApiWorker<ParticleCloud, Void> createAccountTask = null;
    private EditText firstNameView;
    private EditText lastNameView;
    private EditText companyNameView;
    private EditText emailView;
    private EditText passwordView;
    private EditText verifyPasswordView;
    private Switch companyChoiceView;
    private boolean useOrganizationSignup;
    private final CompoundButton.OnCheckedChangeListener companyAccountCheckedListener = CreateAccountActivity$$Lambda$1.lambdaFactory$(this);

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_create_account);
        SEGAnalytics.screen("Auth: Sign Up screen");
        ParticleUi.enableBrandLogoInverseVisibilityAgainstSoftKeyboard((FragmentActivity)this);
        Ui.setText((FragmentActivity)this, R.id.create_account_header_text, Phrase.from((Context)this, (int)R.string.create_account_header_text).put("brand_name", (CharSequence)this.getString(R.string.brand_name)).format());
        this.firstNameView = (EditText)Ui.findView((FragmentActivity)this, R.id.first);
        this.lastNameView = (EditText)Ui.findView((FragmentActivity)this, R.id.last);
        this.companyNameView = (EditText)Ui.findView((FragmentActivity)this, R.id.company);
        this.companyChoiceView = (Switch)Ui.findView((FragmentActivity)this, R.id.companyAccount);
        this.emailView = (EditText)Ui.findView((FragmentActivity)this, R.id.email);
        this.passwordView = (EditText)Ui.findView((FragmentActivity)this, R.id.password);
        this.verifyPasswordView = (EditText)Ui.findView((FragmentActivity)this, R.id.verify_password);
        this.companyChoiceView.setOnCheckedChangeListener(this.companyAccountCheckedListener);
        this.useOrganizationSignup = this.getResources().getBoolean(R.bool.organization);
        Button submit = (Button)Ui.findView((FragmentActivity)this, R.id.action_create_account);
        submit.setOnClickListener(CreateAccountActivity$$Lambda$2.lambdaFactory$(this));
        Ui.setTextFromHtml((FragmentActivity)this, R.id.already_have_an_account_text, R.string.msg_user_already_has_account).setOnClickListener(CreateAccountActivity$$Lambda$3.lambdaFactory$(this));
        if (this.getResources().getBoolean(R.bool.show_sign_up_page_fine_print)) {
            String tosUri = this.getString(R.string.terms_of_service_uri);
            String privacyPolicyUri = this.getString(R.string.privacy_policy_uri);
            String finePrintText = Phrase.from((Context)this, (int)R.string.msg_create_account_disclaimer).put("tos_link", (CharSequence)tosUri).put("privacy_policy_link", (CharSequence)privacyPolicyUri).format().toString();
            Ui.setTextFromHtml((FragmentActivity)this, R.id.fine_print, finePrintText).setMovementMethod(LinkMovementMethod.getInstance());
        } else {
            Ui.findView((FragmentActivity)this, R.id.fine_print).setVisibility(8);
        }
    }

    public void attemptCreateAccount() {
        boolean empty;
        if (this.createAccountTask != null) {
            log.wtf("Sign up being attempted again even though the sign up button isn't enabled?!");
            return;
        }
        this.emailView.setError(null);
        this.passwordView.setError(null);
        this.firstNameView.setError(null);
        this.lastNameView.setError(null);
        this.companyNameView.setError(null);
        String email = this.emailView.getText().toString();
        String password = this.passwordView.getText().toString();
        boolean cancel = false;
        EditText focusView = null;
        if (!Py.truthy((Object)email)) {
            this.emailView.setError((CharSequence)this.getString(R.string.error_field_required));
            focusView = this.emailView;
            cancel = true;
        } else if (!this.isEmailValid(email)) {
            this.emailView.setError((CharSequence)this.getString(R.string.error_invalid_email));
            focusView = this.emailView;
            cancel = true;
        }
        if (TextUtils.isEmpty((CharSequence)password)) {
            this.passwordView.setError((CharSequence)this.getString(R.string.error_field_required));
            focusView = this.passwordView;
            cancel = true;
        } else if (!this.isPasswordValid(password)) {
            this.passwordView.setError((CharSequence)this.getString(R.string.error_invalid_password));
            focusView = this.passwordView;
            cancel = true;
        } else if (!password.equals(this.verifyPasswordView.getText().toString())) {
            this.passwordView.setError((CharSequence)this.getString(R.string.create_account_passswords_do_not_match));
            this.verifyPasswordView.setError((CharSequence)this.getString(R.string.create_account_passswords_do_not_match));
            focusView = this.passwordView;
            cancel = true;
        }
        if (this.companyChoiceView.isChecked()) {
            empty = this.isFieldEmpty(this.companyNameView);
            cancel = empty || cancel;
            focusView = empty ? this.companyNameView : focusView;
        }
        cancel = (empty = this.isFieldEmpty(this.lastNameView)) || cancel;
        focusView = empty ? this.lastNameView : focusView;
        empty = this.isFieldEmpty(this.firstNameView);
        cancel = empty || cancel;
        EditText editText = focusView = empty ? this.firstNameView : focusView;
        if (cancel) {
            focusView.requestFocus();
        } else {
            this.attemptSignUp();
        }
    }

    private void attemptSignUp() {
        final AccountInfo accountInfo = new AccountInfo();
        accountInfo.setFirstName(this.firstNameView.getText().toString());
        accountInfo.setLastName(this.lastNameView.getText().toString());
        accountInfo.setCompanyName(this.companyNameView.getText().toString());
        accountInfo.setBusinessAccount(this.companyChoiceView.isChecked());
        final String email = this.emailView.getText().toString();
        final String password = this.passwordView.getText().toString();
        final SignUpInfo signUpInfo = new SignUpInfo(email, password, accountInfo);
        ParticleUi.showParticleButtonProgress((FragmentActivity)this, R.id.action_create_account, true);
        final ParticleCloud cloud = ParticleCloudSDK.getCloud();
        this.createAccountTask = Async.executeAsync((ParticleCloud)cloud, (Async.ApiWork)new Async.ApiWork<ParticleCloud, Void>(){

            public Void callApi(@NonNull ParticleCloud particleCloud) throws ParticleCloudException {
                if (CreateAccountActivity.this.useOrganizationSignup) {
                    particleCloud.signUpAndLogInWithCustomer(signUpInfo, CreateAccountActivity.this.getString(R.string.organization_slug));
                } else {
                    particleCloud.signUpWithUser(signUpInfo);
                }
                return null;
            }

            public void onTaskFinished() {
                CreateAccountActivity.this.createAccountTask = null;
            }

            public void onSuccess(@NonNull Void result) {
                CreateAccountActivity.this.singUpTaskSuccess(email, password, accountInfo, cloud);
            }

            public void onFailure(@NonNull ParticleCloudException error) {
                CreateAccountActivity.this.signUpTaskFailure(error);
            }
        });
    }

    private void singUpTaskSuccess(String email, String password, AccountInfo accountInfo, ParticleCloud cloud) {
        SEGAnalytics.track("android account creation", new Properties().putValue("email", (Object)email).putValue("firstname", (Object)accountInfo.getFirstName()).putValue("lastname", (Object)accountInfo.getLastName()).putValue("isbusiness", (Object)accountInfo.isBusinessAccount()).putValue("company", (Object)accountInfo.getCompanyName()));
        log.d("onAccountCreated()!");
        if (this.isFinishing()) {
            return;
        }
        if (this.useOrganizationSignup) {
            this.onLoginSuccess(cloud);
            SEGAnalytics.track("Auth: Signed Up New Customer");
        } else {
            SEGAnalytics.track("Auth: Signed Up New User");
            this.attemptLogin(email, password);
        }
    }

    private void signUpTaskFailure(@NonNull ParticleCloudException error) {
        log.d("onFailed()");
        ParticleUi.showParticleButtonProgress((FragmentActivity)this, R.id.action_create_account, false);
        String msg = this.getString(R.string.create_account_unknown_error);
        if (error.getKind() == ParticleCloudException.Kind.NETWORK) {
            msg = this.getString(R.string.create_account_error_communicating_with_server);
        } else if (error.getResponseData() != null) {
            msg = error.getResponseData().getHttpStatusCode() == 401 && this.getResources().getBoolean(R.bool.organization) ? this.getString(R.string.create_account_account_already_exists_for_email_address) : error.getServerErrorMsg();
        }
        Toaster.l((Context)this, msg, 16);
        this.emailView.requestFocus();
    }

    private boolean isFieldEmpty(EditText formField) {
        if (TextUtils.isEmpty((CharSequence)formField.getText().toString())) {
            formField.setError((CharSequence)this.getString(R.string.error_field_required));
            return true;
        }
        return false;
    }

    private boolean isEmailValid(String email) {
        return Patterns.EMAIL_ADDRESS.matcher(email).matches();
    }

    private boolean isPasswordValid(String password) {
        return password.length() > 0;
    }

    private void onLoginSuccess(ParticleCloud cloud) {
        this.startActivity(NextActivitySelector.getNextActivityIntent((Context)this, cloud, SDKGlobals.getSensitiveDataStorage(), null));
        this.finish();
    }

    private void attemptLogin(final String username, final String password) {
        final ParticleCloud cloud = ParticleCloudSDK.getCloud();
        Async.executeAsync((ParticleCloud)cloud, (Async.ApiWork)new Async.ApiWork<ParticleCloud, Void>(){

            public Void callApi(@NonNull ParticleCloud particleCloud) throws ParticleCloudException {
                particleCloud.logIn(username, password);
                return null;
            }

            public void onSuccess(@NonNull Void result) {
                log.d("Logged in...");
                if (CreateAccountActivity.this.isFinishing()) {
                    return;
                }
                CreateAccountActivity.this.onLoginSuccess(cloud);
            }

            public void onFailure(@NonNull ParticleCloudException error) {
                log.w("onFailed(): " + error.getMessage());
                ParticleUi.showParticleButtonProgress((FragmentActivity)CreateAccountActivity.this, R.id.action_create_account, false);
                CreateAccountActivity.this.passwordView.setError((CharSequence)error.getBestMessage());
                CreateAccountActivity.this.passwordView.requestFocus();
            }
        });
    }

    /* synthetic */ void lambda$onCreate$2(View v) {
        this.startActivity(new Intent(v.getContext(), LoginActivity.class));
        this.finish();
    }

    /* synthetic */ void lambda$onCreate$1(View view) {
        this.attemptCreateAccount();
    }

    /* synthetic */ void lambda$new$0(CompoundButton buttonView, boolean isChecked) {
        if (isChecked) {
            int backgroundDefault = ContextCompat.getColor((Context)this, (int)R.color.register_field_background_color_enabled);
            this.verifyPasswordView.setImeOptions(5);
            this.companyNameView.setBackgroundColor(backgroundDefault);
            this.companyChoiceView.setText(R.string.prompt_company_account_enabled);
        } else {
            this.verifyPasswordView.setImeOptions(6);
            this.companyNameView.setBackgroundColor(ContextCompat.getColor((Context)this, (int)R.color.register_field_background_color_disabled));
            this.companyChoiceView.setText(R.string.prompt_company_account_disabled);
        }
        this.companyNameView.setEnabled(isChecked);
    }
}

