/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.ui;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.Loader;
import android.support.v7.app.AlertDialog;
import android.view.View;
import io.particle.android.sdk.devicesetup.R;
import io.particle.android.sdk.devicesetup.commands.CommandClient;
import io.particle.android.sdk.devicesetup.commands.InterfaceBindingSocketFactory;
import io.particle.android.sdk.devicesetup.commands.data.WifiSecurity;
import io.particle.android.sdk.devicesetup.loaders.ScanApCommandLoader;
import io.particle.android.sdk.devicesetup.model.ScanAPCommandResult;
import io.particle.android.sdk.devicesetup.ui.ConnectingActivity;
import io.particle.android.sdk.devicesetup.ui.ManualNetworkEntryActivity;
import io.particle.android.sdk.devicesetup.ui.PasswordEntryActivity;
import io.particle.android.sdk.devicesetup.ui.RequiresWifiScansActivity;
import io.particle.android.sdk.devicesetup.ui.WifiListFragment;
import io.particle.android.sdk.utils.WiFi;
import io.particle.android.sdk.utils.ui.ParticleUi;
import io.particle.android.sdk.utils.ui.Ui;
import java.util.Set;

public class SelectNetworkActivity
extends RequiresWifiScansActivity
implements WifiListFragment.Client<ScanAPCommandResult> {
    private WifiListFragment wifiListFragment;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_select_network);
        this.wifiListFragment = (WifiListFragment)((Object)Ui.findFrag((FragmentActivity)this, R.id.wifi_list_fragment));
        Ui.findView((FragmentActivity)this, R.id.action_rescan).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ParticleUi.showParticleButtonProgress((FragmentActivity)SelectNetworkActivity.this, R.id.action_rescan, true);
                SelectNetworkActivity.this.wifiListFragment.scanAsync();
            }
        });
    }

    public void onManualNetworkEntryClicked(View view) {
        this.startActivity(new Intent((Context)this, ManualNetworkEntryActivity.class));
        this.finish();
    }

    @Override
    public void onNetworkSelected(ScanAPCommandResult selectedNetwork) {
        if (WifiSecurity.isEnterpriseNetwork(selectedNetwork.scan.wifiSecurityType)) {
            new AlertDialog.Builder((Context)this).setMessage((CharSequence)this.getString(R.string.enterprise_networks_not_supported)).setPositiveButton(R.string.ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            }).show();
            return;
        }
        this.wifiListFragment.stopAggroLoading();
        String softApSSID = WiFi.getCurrentlyConnectedSSID((Context)this);
        if (selectedNetwork.isSecured()) {
            this.startActivity(PasswordEntryActivity.buildIntent((Context)this, selectedNetwork.scan));
        } else {
            this.startActivity(ConnectingActivity.buildIntent((Context)this, softApSSID, selectedNetwork.scan));
        }
        this.finish();
    }

    @Override
    public Loader<Set<ScanAPCommandResult>> createLoader(int id2, Bundle args) {
        CommandClient client = CommandClient.newClientUsingDefaultSocketAddress();
        return new ScanApCommandLoader(this.getApplicationContext(), client, new InterfaceBindingSocketFactory((Context)this));
    }

    @Override
    public void onLoadFinished() {
        ParticleUi.showParticleButtonProgress((FragmentActivity)this, R.id.action_rescan, false);
    }

    @Override
    public String getListEmptyText() {
        return this.getString(R.string.no_wifi_networks_found);
    }

    @Override
    public int getAggroLoadingTimeMillis() {
        return 10000;
    }
}

