/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.utils;

import com.google.common.io.BaseEncoding;
import io.particle.android.sdk.utils.TLog;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

@ParametersAreNonnullByDefault
public class Crypto {
    private static final TLog log = TLog.get(Crypto.class);

    public static PublicKey readPublicKeyFromHexEncodedDerString(String hexBytes) throws CryptoException {
        byte[] rawBytes = BaseEncoding.base16().decode((CharSequence)hexBytes);
        return Crypto.buildPublicKey(rawBytes);
    }

    public static String encryptAndEncodeToHex(String inputString, PublicKey publicKey) throws CryptoException {
        byte[] asBytes = null;
        Charset utf8 = Charset.forName("UTF-8");
        asBytes = inputString.getBytes(utf8);
        byte[] encryptedBytes = Crypto.encryptWithKey(asBytes, publicKey);
        String hex = BaseEncoding.base16().encode(encryptedBytes);
        return hex.toLowerCase();
    }

    static byte[] encryptWithKey(byte[] inputData, PublicKey publicKey) throws CryptoException {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(1, publicKey);
            return cipher.doFinal(inputData);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            log.e("Error while encrypting bytes: ", (Throwable)e);
            throw new CryptoException(e);
        }
    }

    static PublicKey buildPublicKey(byte[] rawBytes) throws CryptoException {
        X509EncodedKeySpec spec = new X509EncodedKeySpec(rawBytes);
        KeyFactory kf = Crypto.getRSAKeyFactory();
        try {
            return kf.generatePublic(spec);
        }
        catch (InvalidKeySpecException e) {
            throw new CryptoException(e);
        }
    }

    static KeyFactory getRSAKeyFactory() {
        try {
            return KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("This should be impossible, but there is no RSA impl on this device", e);
        }
    }

    public static class CryptoException
    extends Exception {
        public CryptoException(Throwable cause) {
            super(cause);
        }
    }
}

